/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.net.SocketWrapper;

public class UpgradeAprProcessor
extends UpgradeProcessor<Long> {
    private final long socket;

    public UpgradeAprProcessor(SocketWrapper<Long> wrapper, UpgradeInbound upgradeInbound) {
        super(upgradeInbound);
        Socket.timeoutSet((long)((Long)wrapper.getSocket()), (long)upgradeInbound.getReadTimeout());
        this.socket = (Long)wrapper.getSocket();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int b) throws IOException {
        Socket.send((long)this.socket, (byte[])new byte[]{(byte)b}, (int)0, (int)1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Socket.send((long)this.socket, (byte[])b, (int)off, (int)len);
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int result = Socket.recv((long)this.socket, (byte[])bytes, (int)0, (int)1);
        if (result == -1) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(boolean block, byte[] bytes, int off, int len) throws IOException {
        if (!block) {
            Socket.optSet((long)this.socket, (int)8, (int)-1);
        }
        try {
            int result = Socket.recv((long)this.socket, (byte[])bytes, (int)off, (int)len);
            if (result > 0) {
                int n = result;
                return n;
            }
            if (-result == 120002) {
                int n = 0;
                return n;
            }
            throw new IOException(sm.getString("apr.error", new Object[]{-result}));
        }
        finally {
            if (!block) {
                Socket.optSet((long)this.socket, (int)8, (int)0);
            }
        }
    }
}

