/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.tomcat.ext.internal.CarbonTomcatServiceHolder;

public class ServletTransportManager {
    private static Log log = LogFactory.getLog(ServletTransportManager.class);
    private static int httpPort;
    private static int httpsPort;
    private static int portOffset;

    public static void init() {
        ServerConfigurationService serverConfigurationService = CarbonTomcatServiceHolder.getServerConfigurationService();
        String portOffset = System.getProperty("portOffset", serverConfigurationService.getFirstProperty("Ports.Offset"));
        ServletTransportManager.portOffset = Integer.parseInt(portOffset);
        httpPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getPort("http") + ServletTransportManager.portOffset;
        System.setProperty("mgt.transport.http.port", String.valueOf(httpPort));
        httpsPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getPort("https") + ServletTransportManager.portOffset;
        System.setProperty("mgt.transport.https.port", String.valueOf(httpsPort));
    }

    public static int getPort(String scheme) {
        if ("http".equals(scheme)) {
            return httpPort;
        }
        if ("https".equals(scheme)) {
            return httpsPort;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unrecognized transport scheme" + scheme));
        }
        return -1;
    }

    public static void startTransports() {
        CarbonTomcatServiceHolder.getCarbonTomcatService().startConnectors(portOffset);
    }

    public static void stopTransports() {
        CarbonTomcatServiceHolder.getCarbonTomcatService().stopConnectors();
    }

    public static void startTransport(String scheme) {
        CarbonTomcatServiceHolder.getCarbonTomcatService().startConnector(scheme, portOffset);
    }

    public static void stopTransport(String scheme) {
        CarbonTomcatServiceHolder.getCarbonTomcatService().stopConnector(scheme);
    }
}

