/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.tasks;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.conf.ThrottlingTaskDataProviderConfiguration;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.dataproviders.DataProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.rules.RuleInvoker;
import org.wso2.carbon.throttling.manager.utils.DataProviderIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task {
    private static final Log log = LogFactory.getLog(Task.class);
    private static final int DEFAULT_INTERVAL = 15;
    Map<String, String> parameters;
    DataProviderIterator dataProviderIterator;
    RuleInvoker ruleInvoker;

    public Task(Map<String, String> parameters, List<ThrottlingTaskDataProviderConfiguration> dataProviderConfigs) throws ThrottlingException {
        this.parameters = parameters;
        this.dataProviderIterator = new DataProviderIterator(dataProviderConfigs);
        this.ruleInvoker = new RuleInvoker();
    }

    public void prepareData(ThrottlingDataContext dataContext) throws ThrottlingException {
        this.dataProviderIterator.reset();
        while (this.dataProviderIterator.hasNext()) {
            DataProvider dataProvider = (DataProvider)this.dataProviderIterator.next();
            if (dataProvider == null) {
                String msg = "Error in invoking the data provider. dataProviderConfigs is null or data provider is not yet loaded";
                log.error((Object)msg);
                throw new ThrottlingException(msg);
            }
            dataProvider.invoke(dataContext);
            if (!dataContext.isProcessingComplete()) continue;
            break;
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public int getTriggerInterval() {
        if (this.parameters == null || this.parameters.get("interval") == null) {
            return 900000;
        }
        return Integer.parseInt(this.parameters.get("interval")) * 60 * 1000;
    }

    public int getStartDelayInterval() {
        if (this.parameters == null || this.parameters.get("delay") == null) {
            return 900000;
        }
        return Integer.parseInt(this.parameters.get("delay")) * 60 * 1000;
    }

    public RuleInvoker getRuleInvoker() {
        return this.ruleInvoker;
    }
}

