/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.mgt.api.MultitenancyBillingInfo;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.throttling.manager.utils.Util;
import org.wso2.carbon.usage.api.TenantUsageRetriever;
import org.wso2.carbon.user.core.service.RealmService;

public class ThrottlingManagerServiceComponent {
    private static Log log = LogFactory.getLog(ThrottlingManagerServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            Util.setBundleContext(context.getBundleContext());
            Util.loadThrottlingRules();
            Util.registerThrottlingRuleInvoker();
            Util.initializeThrottling();
            log.debug((Object)" Multitenancy Throttling Manager bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)" Multitenancy Throttling Manager bundle failed activating ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Throttling Manager bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void setBillingManager(BillingManager billingManager) {
        log.debug((Object)"Receiving billingManager service");
        Util.setBillingManager(billingManager);
    }

    protected void unsetBillingManager(BillingManager billingManager) {
        log.debug((Object)"Halting billingManager service");
        Util.setBillingManager(null);
    }

    protected void setRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
        Util.setRuleEngineConfigService(ruleEngineConfigService);
    }

    protected void unsetRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
    }

    protected void setTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        log.debug((Object)"Setting Tenant Usage Retriever service");
        Util.setTenantUsageRetriever(tenantUsageRetriever);
    }

    protected void unsetTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        log.debug((Object)"Unsetting Tenant Usage Retriever service");
        Util.setBillingManager(null);
    }

    protected void setMultitenancyBillingInfo(MultitenancyBillingInfo mtBillingInfo) {
        log.debug((Object)"Setting MT billing info service");
        Util.setMultitenancyBillingInfo(mtBillingInfo);
    }

    protected void unsetMultitenancyBillingInfo(MultitenancyBillingInfo mtBillingInfo) {
        log.debug((Object)"Unsetting MT billing info service");
        Util.setMultitenancyBillingInfo(null);
    }
}

