/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.dataobjects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingAccessValidation;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingDataContext {
    int tenantId;
    String userName;
    Map<String, ThrottlingDataEntry> data;
    boolean async = false;
    String taskName = null;
    private ThrottlingAccessValidation accessValidation;
    boolean processingComplete;

    public ThrottlingDataContext(int tenantId) {
        this.tenantId = tenantId;
        this.data = new HashMap<String, ThrottlingDataEntry>();
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ThrottlingAccessValidation getAccessValidation() {
        return this.accessValidation;
    }

    public void setAccessValidation(ThrottlingAccessValidation accessValidation) {
        this.accessValidation = accessValidation;
    }

    public boolean isProcessingComplete() {
        return this.processingComplete;
    }

    public void setProcessingComplete(boolean processingComplete) {
        this.processingComplete = processingComplete;
    }

    public Collection<ThrottlingDataEntry> getData() {
        return this.data.values();
    }

    public void addDataString(String key, String value) {
        ThrottlingDataEntry dataEntry = new ThrottlingDataEntry(key);
        dataEntry.setStringValue(value);
        this.data.put(key, dataEntry);
    }

    public void addDataLong(String key, long value) {
        ThrottlingDataEntry dataEntry = new ThrottlingDataEntry(key);
        dataEntry.setLongValue(value);
        this.data.put(key, dataEntry);
    }

    public void addDataInt(String key, int value) {
        ThrottlingDataEntry dataEntry = new ThrottlingDataEntry(key);
        dataEntry.setIntValue(value);
        this.data.put(key, dataEntry);
    }

    public void addDataObject(String key, Object value) {
        ThrottlingDataEntry dataEntry = new ThrottlingDataEntry(key);
        dataEntry.setObjectValue(value);
        this.data.put(key, dataEntry);
    }

    public String getDataString(String key) {
        ThrottlingDataEntry dataEntry = this.data.get(key);
        if (dataEntry == null) {
            return null;
        }
        return dataEntry.getStringValue();
    }

    public long getDataLong(String key) {
        ThrottlingDataEntry dataEntry = this.data.get(key);
        if (dataEntry == null) {
            return 0L;
        }
        return dataEntry.getLongValue();
    }

    public int getDataInt(String key) {
        ThrottlingDataEntry dataEntry = this.data.get(key);
        if (dataEntry == null) {
            return 0;
        }
        return dataEntry.getIntValue();
    }

    public Object getDataObject(String key) {
        ThrottlingDataEntry dataEntry = this.data.get(key);
        if (dataEntry == null) {
            return null;
        }
        return dataEntry.getObjectValue();
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }
}

