/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.conf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.dataproviders.DataProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.utils.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingTaskDataProviderConfiguration {
    private static final Log log = LogFactory.getLog(ThrottlingTaskDataProviderConfiguration.class);
    private static final String CONFIG_NS = "http://wso2.com/carbon/multitenancy/throttling/config";
    private static final String HANDLER_CONF_PARAM_KEY = "parameter";
    private static final String HANDLER_CLASS_ATTR = "class";
    private static final String HANDLER_CONF_PARAM_NAME_KEY = "name";
    private static final String HANDLER_SERVICE_ATTR = "service";
    private String dataProviderServiceName;
    private Map<String, String> dataProviderParameters;
    private DataProvider dataProvider;
    private Map<String, DataProvider> dataProviders;

    public ThrottlingTaskDataProviderConfiguration(OMElement handlerConfigEle) throws ThrottlingException {
        this.serialize(handlerConfigEle);
        this.dataProviders = new HashMap<String, DataProvider>();
    }

    private void serialize(OMElement handlerConfigEle) throws ThrottlingException {
        Iterator handlerParameterChildIt = handlerConfigEle.getChildElements();
        Map<String, String> parameters = ThrottlingTaskDataProviderConfiguration.extractParameters(handlerParameterChildIt);
        String handlerClassName = handlerConfigEle.getAttributeValue(new QName(HANDLER_CLASS_ATTR));
        if (handlerClassName == null) {
            this.dataProviderServiceName = handlerConfigEle.getAttributeValue(new QName(HANDLER_SERVICE_ATTR));
            this.dataProviderParameters = parameters;
        } else {
            this.dataProvider = (DataProvider)Util.constructObject(handlerClassName);
            this.dataProvider.init(parameters);
        }
    }

    private static Map<String, String> extractParameters(Iterator parameterIt) throws ThrottlingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (parameterIt.hasNext()) {
            OMElement configChildEle;
            Object parameterObj = parameterIt.next();
            if (!(parameterObj instanceof OMElement) || !new QName(CONFIG_NS, HANDLER_CONF_PARAM_KEY, "").equals((configChildEle = (OMElement)parameterObj).getQName())) continue;
            String paramName = configChildEle.getAttributeValue(new QName(HANDLER_CONF_PARAM_NAME_KEY));
            String paramValue = configChildEle.getText();
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    public DataProvider getDataProvider() throws ThrottlingException {
        if (this.dataProvider == null && this.dataProviderServiceName != null) {
            this.dataProvider = this.dataProviders.get(this.dataProviderServiceName);
            if (this.dataProvider == null) {
                String msg = "The scheduler helper service: " + this.dataProviderServiceName + " is not loaded.";
                log.error((Object)msg);
                throw new ThrottlingException(msg);
            }
            this.dataProvider.init(this.dataProviderParameters);
        }
        return this.dataProvider;
    }

    public void loadDataProviderService() throws ThrottlingException {
        if (this.dataProvider == null && this.dataProviderServiceName != null) {
            this.dataProvider = this.dataProviders.get(this.dataProviderServiceName);
            if (this.dataProvider != null) {
                this.dataProvider.init(this.dataProviderParameters);
            }
        }
    }
}

