/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.throttling.manager.conf.ThrottlingTaskConfiguration;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingConfiguration {
    private static final Log log = LogFactory.getLog(ThrottlingConfiguration.class);
    private static final String CONFIG_NS = "http://wso2.com/carbon/multitenancy/usage-throttling-agent/config";
    List<ThrottlingTaskConfiguration> throttlingTaskConfigs;
    List<Task> tasks;

    public ThrottlingConfiguration(String throttlingConfigFile) throws ThrottlingException {
        try {
            OMElement throttlingConfig = CommonUtil.buildOMElement((InputStream)new FileInputStream(throttlingConfigFile));
            this.deserialize(throttlingConfig);
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to find the file: " + throttlingConfigFile + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error in building the throttling config, config file: " + throttlingConfigFile + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
    }

    public void deserialize(OMElement throttlingConfigEle) throws ThrottlingException {
        OMElement throttlingManagerConfigs = null;
        Iterator childElements = throttlingConfigEle.getChildElements();
        while (childElements.hasNext()) {
            OMElement configChildOMElement;
            Object configChildElement = childElements.next();
            if (!(configChildElement instanceof OMElement) || !new QName(CONFIG_NS, "ThrottlingManagerTask", "").equals((configChildOMElement = (OMElement)configChildElement).getQName())) continue;
            throttlingManagerConfigs = (OMElement)configChildElement;
        }
        Iterator throttlingConfigChildIt = throttlingManagerConfigs.getChildElements();
        while (throttlingConfigChildIt.hasNext()) {
            OMElement throttlingConfigChildEle;
            Object throttlingConfigChild = throttlingConfigChildIt.next();
            if (!(throttlingConfigChild instanceof OMElement) || !new QName(CONFIG_NS, "tasks", "").equals((throttlingConfigChildEle = (OMElement)throttlingConfigChild).getQName())) continue;
            this.throttlingTaskConfigs = new ArrayList<ThrottlingTaskConfiguration>();
            this.tasks = new ArrayList<Task>();
            Iterator tasksConfigChildIt = throttlingConfigChildEle.getChildElements();
            while (tasksConfigChildIt.hasNext()) {
                Object taskConfigChild = tasksConfigChildIt.next();
                if (!(taskConfigChild instanceof OMElement)) continue;
                ThrottlingTaskConfiguration taskConfiguration = new ThrottlingTaskConfiguration((OMElement)taskConfigChild);
                this.throttlingTaskConfigs.add(taskConfiguration);
                this.tasks.add(taskConfiguration.getTask());
            }
        }
    }

    public List<ThrottlingTaskConfiguration> getThrottlingTaskConfigs() {
        return this.throttlingTaskConfigs;
    }

    public List<Task> getThrottlingTasks() {
        return this.tasks;
    }
}

