/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.validation;

import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.MeteringAccessValidationUtils;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingAccessValidation;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.utils.Util;

public class ValidationInfoManager {
    private static final Log log = LogFactory.getLog(ValidationInfoManager.class);

    public static void loadValidationDetails(ThrottlingDataContext throttlingDataContext) throws ThrottlingException {
        int tenantId = throttlingDataContext.getTenantId();
        String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenantId;
        ThrottlingAccessValidation accessValidation = throttlingDataContext.getAccessValidation();
        if (accessValidation == null) {
            accessValidation = new ThrottlingAccessValidation();
            throttlingDataContext.setAccessValidation(accessValidation);
        }
        try {
            UserRegistry governanceSystemRegistry = Util.getSuperTenantGovernanceSystemRegistry();
            if (governanceSystemRegistry.resourceExists(tenantValidationInfoResourcePath)) {
                Resource tenantValidationInfoResource = governanceSystemRegistry.get(tenantValidationInfoResourcePath);
                Properties properties = tenantValidationInfoResource.getProperties();
                Set actions = MeteringAccessValidationUtils.getAvailableActions((Properties)properties);
                for (String action : actions) {
                    String blockActionStr = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action));
                    String blockActionMsg = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action));
                    accessValidation.setTenantBlocked(action, "true".equals(blockActionStr), blockActionMsg);
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting the tenant validation info.  tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, (Exception)((Object)e));
        }
    }

    public static void persistValidationDetails(ThrottlingDataContext throttlingDataContext) throws ThrottlingException {
        int tenantId = throttlingDataContext.getTenantId();
        String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenantId;
        ThrottlingAccessValidation accessValidation = throttlingDataContext.getAccessValidation();
        try {
            UserRegistry governanceSystemRegistry = Util.getSuperTenantGovernanceSystemRegistry();
            Resource tenantValidationInfoResource = governanceSystemRegistry.resourceExists(tenantValidationInfoResourcePath) ? governanceSystemRegistry.get(tenantValidationInfoResourcePath) : governanceSystemRegistry.newResource();
            Set<String> actions = accessValidation.getActions();
            for (String action : actions) {
                boolean blockAction = accessValidation.isTenantBlocked(action);
                String blockActionMsg = accessValidation.getTenantBlockedMsg(action);
                tenantValidationInfoResource.setProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action), blockAction ? "true" : "false");
                tenantValidationInfoResource.setProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action), blockActionMsg);
            }
            governanceSystemRegistry.put(tenantValidationInfoResourcePath, tenantValidationInfoResource);
        }
        catch (RegistryException e) {
            String msg = "Error in storing the tenant validation info.  tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, (Exception)((Object)e));
        }
    }
}

