/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.services;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.throttling.manager.rules.RuleInvoker;
import org.wso2.carbon.throttling.manager.tasks.Task;
import org.wso2.carbon.throttling.manager.utils.Util;

public class ThrottlingRuleEditorService {
    private static final Log log = LogFactory.getLog(ThrottlingRuleEditorService.class);

    public String retrieveThrottlingRules() throws Exception {
        UserRegistry systemRegistry = Util.getSuperTenantGovernanceSystemRegistry();
        Resource ruleContentResource = systemRegistry.get("/repository/components/org.wso2.carbon.throttling-rules");
        Object ruleContent = ruleContentResource.getContent();
        if (ruleContent instanceof String) {
            return (String)ruleContent;
        }
        if (ruleContent instanceof byte[]) {
            return new String((byte[])ruleContent);
        }
        String msg = "Unidentified type for the registry resource content. type: " + ruleContent.getClass().getName();
        log.error((Object)msg);
        throw new Exception(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThrottlingRules(String ruleContent) throws Exception {
        boolean updateSuccess = false;
        UserRegistry systemRegistry = Util.getSuperTenantGovernanceSystemRegistry();
        try {
            systemRegistry.beginTransaction();
            Resource ruleContentResource = systemRegistry.get("/repository/components/org.wso2.carbon.throttling-rules");
            ruleContentResource.setContent((Object)ruleContent);
            systemRegistry.put("/repository/components/org.wso2.carbon.throttling-rules", ruleContentResource);
            List<Task> tasks = Util.getTasks();
            for (Task task : tasks) {
                RuleInvoker ruleInvoker = task.getRuleInvoker();
                ruleInvoker.updateRules();
            }
            updateSuccess = true;
        }
        finally {
            if (updateSuccess) {
                systemRegistry.commitTransaction();
            } else {
                systemRegistry.rollbackTransaction();
            }
        }
    }
}

