/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.scheduling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.rules.KnowledgeBaseManager;
import org.wso2.carbon.throttling.manager.rules.RuleInvoker;
import org.wso2.carbon.throttling.manager.tasks.Task;
import org.wso2.carbon.throttling.manager.utils.Util;
import org.wso2.carbon.throttling.manager.validation.ValidationInfoManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.Tenant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingJob
implements Job {
    private static final Log log = LogFactory.getLog(ThrottlingJob.class);
    public static final String THROTTLING_TASK_CONTEXT_KEY = "throttlingTask";

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Task task = (Task)jobExecutionContext.getMergedJobDataMap().get((Object)THROTTLING_TASK_CONTEXT_KEY);
        this.executeTask(task);
    }

    public void executeTask(Task task) throws JobExecutionException {
        Map<Integer, ThrottlingDataContext> contextMap;
        ArrayList<Object> knowledgeBase = new ArrayList<Object>();
        try {
            contextMap = this.feedKnowledgeBase(task, knowledgeBase);
        }
        catch (ThrottlingException e) {
            String msg = "Error in feeding knowledge base.";
            log.error((Object)msg, (Throwable)e);
            throw new JobExecutionException(msg, (Throwable)e);
        }
        RuleInvoker ruleInvoker = task.getRuleInvoker();
        try {
            ruleInvoker.updateRules();
            ruleInvoker.invoke(knowledgeBase);
            log.info((Object)"Throttling rules executed successfully");
        }
        catch (ThrottlingException e) {
            String msg = "Error in invoking the throttling rule invoker.";
            log.error((Object)msg, (Throwable)e);
            throw new JobExecutionException(msg, (Throwable)e);
        }
        for (int tenantId : contextMap.keySet()) {
            ThrottlingDataContext dataContext = contextMap.get(tenantId);
            try {
                ValidationInfoManager.persistValidationDetails(dataContext);
            }
            catch (ThrottlingException e) {
                String msg = "Error in persisting validation details. Tenant id: " + tenantId + ".";
                log.error((Object)msg, (Throwable)e);
                throw new JobExecutionException(msg, (Throwable)e);
            }
        }
    }

    private Map<Integer, ThrottlingDataContext> feedKnowledgeBase(Task task, List<Object> knowledgeBase) throws ThrottlingException {
        Tenant[] tenants;
        HashMap<Integer, ThrottlingDataContext> contextMap = new HashMap<Integer, ThrottlingDataContext>();
        try {
            tenants = Util.getAllTenants();
        }
        catch (UserStoreException e) {
            String msg = "Error in getting all the tenants.";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, (Exception)((Object)e));
        }
        for (Tenant tenant : tenants) {
            if (!tenant.isActive()) continue;
            int tenantId = tenant.getId();
            ThrottlingDataContext throttlingDataContext = KnowledgeBaseManager.feedKnowledgeBase(tenantId, task, knowledgeBase);
            contextMap.put(tenantId, throttlingDataContext);
        }
        return contextMap;
    }
}

