/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.dataproviders;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.dataproviders.DataProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.utils.Util;
import org.wso2.carbon.usage.api.TenantUsageRetriever;
import org.wso2.carbon.usage.beans.BandwidthStatistics;
import org.wso2.carbon.usage.beans.RequestStatistics;
import org.wso2.carbon.usage.beans.TenantUsage;

public class UsageDataProvider
extends DataProvider {
    private static final Log log = LogFactory.getLog(UsageDataProvider.class);

    public void invoke(ThrottlingDataContext dataContext) throws ThrottlingException {
        int tenantId = dataContext.getTenantId();
        String userName = dataContext.getUserName();
        String yearMonth = Util.getCurrentMonthString(Calendar.getInstance());
        TenantUsageRetriever tenantUsageRetriever = Util.getTenantUsageRetriever();
        try {
            TenantUsage usage = tenantUsageRetriever.getTenantUsage(tenantId, yearMonth);
            long tenantIncomingBandwidth = usage.getTotalIncomingBandwidth();
            long tenantOutgoingBandwidth = usage.getTotalOutgoingBandwidth();
            dataContext.addDataLong("tenantIncomingBandwidth", tenantIncomingBandwidth);
            dataContext.addDataLong("tenantOutgoingBandwidth", tenantOutgoingBandwidth);
            long currentTenantCapacity = usage.getRegistryContentCapacity();
            long historyTenantCapacity = usage.getRegistryContentHistoryCapacity();
            dataContext.addDataLong("tenantCapacity", currentTenantCapacity);
            dataContext.addDataLong("tenantHistoryCapacity", historyTenantCapacity);
            BandwidthStatistics totalRgistryBW = usage.getTotalRegistryBandwidth();
            dataContext.addDataLong("registryIncomingBandwidth", totalRgistryBW.getIncomingBandwidth());
            dataContext.addDataLong("registryOutgoingBandwidth", totalRgistryBW.getOutgoingBandwidth());
            BandwidthStatistics serviceBWStatistic = usage.getTotalServiceBandwidth();
            dataContext.addDataLong("serviceIncomingBandwidth", serviceBWStatistic.getIncomingBandwidth());
            dataContext.addDataLong("serviceOutgoingBandwidth", serviceBWStatistic.getOutgoingBandwidth());
            BandwidthStatistics webappBWStatistic = usage.getTotalWebappBandwidth();
            dataContext.addDataLong("webappIncomingBandwidth", webappBWStatistic.getIncomingBandwidth());
            dataContext.addDataLong("webappOutgoingBandwidth", webappBWStatistic.getOutgoingBandwidth());
            RequestStatistics requestStat = usage.getTotalRequestStatistics();
            dataContext.addDataLong("serviceRequestCount", requestStat.getRequestCount());
            dataContext.addDataLong("serviceResponseCount", requestStat.getResponseCount());
            int usersCount = usage.getNumberOfUsers();
            dataContext.addDataInt("usersCount", usersCount);
        }
        catch (Exception e) {
            String msg = "Error in retrieving Usage information. tenant id: " + tenantId + ", user name: " + userName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
    }
}

