/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.conf.ThrottlingTaskDataProviderConfiguration;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingTaskConfiguration {
    private static final Log log = LogFactory.getLog(ThrottlingTaskConfiguration.class);
    private static final String CONFIG_NS = "http://wso2.com/carbon/multitenancy/usage-throttling-agent/config";
    private static final String TASK_CONF_PARAMERTERS = "parameters";
    private static final String TASK_CONF_DATA_PROVIDERS = "dataProviders";
    private static final String TASK_CONF_PARAM_KEY = "parameter";
    private static final String TASK_CONF_PARAM_NAME_KEY = "name";
    public static final String INTERVAL_PARAM_KEY = "interval";
    public static final String DELAY_PARAM_KEY = "delay";
    Task task;
    List<ThrottlingTaskDataProviderConfiguration> dataProviderConfigs = new ArrayList<ThrottlingTaskDataProviderConfiguration>();
    Map<String, String> taskParameters;

    public ThrottlingTaskConfiguration(OMElement taskConfigEle) throws ThrottlingException {
        this.serialize(taskConfigEle);
    }

    private void serialize(OMElement taskConfigEle) throws ThrottlingException {
        Iterator taskConfigChildIt = taskConfigEle.getChildElements();
        while (taskConfigChildIt.hasNext()) {
            Object taskConfigChildObj = taskConfigChildIt.next();
            if (!(taskConfigChildObj instanceof OMElement)) continue;
            OMElement taskConfigChildEle = (OMElement)taskConfigChildObj;
            if (taskConfigChildEle.getQName().equals(new QName(CONFIG_NS, TASK_CONF_PARAMERTERS))) {
                Iterator parametersIt = taskConfigChildEle.getChildElements();
                this.taskParameters = ThrottlingTaskConfiguration.extractTaskParameters(parametersIt);
                continue;
            }
            if (!taskConfigChildEle.getQName().equals(new QName(CONFIG_NS, TASK_CONF_DATA_PROVIDERS))) continue;
            Iterator handlerConfigIt = taskConfigChildEle.getChildElements();
            while (handlerConfigIt.hasNext()) {
                Object handlerConfigObj = handlerConfigIt.next();
                if (!(handlerConfigObj instanceof OMElement)) continue;
                OMElement handlerConfigEle = (OMElement)handlerConfigObj;
                ThrottlingTaskDataProviderConfiguration handlerConfig = new ThrottlingTaskDataProviderConfiguration(handlerConfigEle);
                this.dataProviderConfigs.add(handlerConfig);
            }
        }
        this.task = new Task(this.taskParameters, this.dataProviderConfigs);
    }

    private static Map<String, String> extractTaskParameters(Iterator parameterIt) throws ThrottlingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (parameterIt.hasNext()) {
            OMElement configChildEle;
            Object parameterObj = parameterIt.next();
            if (!(parameterObj instanceof OMElement) || !new QName(CONFIG_NS, TASK_CONF_PARAM_KEY, "").equals((configChildEle = (OMElement)parameterObj).getQName())) continue;
            String paramName = configChildEle.getAttributeValue(new QName(TASK_CONF_PARAM_NAME_KEY));
            String paramValue = configChildEle.getText();
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    public List<ThrottlingTaskDataProviderConfiguration> getDataProviderConfigs() {
        return this.dataProviderConfigs;
    }

    public Task getTask() {
        return this.task;
    }
}

