/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottleFactory;

public class ThrottleEnguageUtils {
    private static Log log = LogFactory.getLog((String)ThrottleEnguageUtils.class.getName());

    public static void enguage(AxisDescription axisDescription, ConfigurationContext configctx, Throttle defaultThrottle) throws AxisFault {
        if (axisDescription instanceof AxisService) {
            Throttle throttle = null;
            AxisService currentService = (AxisService)axisDescription;
            PolicySubject policySubject = currentService.getPolicySubject();
            if (policySubject != null) {
                try {
                    ArrayList policies = new ArrayList(policySubject.getAttachedPolicyComponents());
                    Policy currentPolicy = PolicyUtil.getMergedPolicy(policies, (AxisService)currentService);
                    if (currentPolicy != null) {
                        throttle = ThrottleFactory.createServiceThrottle(currentPolicy);
                        if (throttle == null) {
                            throttle = defaultThrottle;
                        }
                    } else {
                        AxisConfiguration axisConfig = configctx.getAxisConfiguration();
                        AxisModule throttleModule = axisConfig.getModule("wso2throttle");
                        policySubject = throttleModule.getPolicySubject();
                        if (policySubject != null && (currentPolicy = ThrottleEnguageUtils.getThrottlePolicy(policySubject.getAttachedPolicyComponents())) != null) {
                            throttle = ThrottleFactory.createModuleThrottle(currentPolicy);
                        }
                    }
                }
                catch (ThrottleException e) {
                    log.error((Object)("Error was occurred when engaging throttle module for the service :" + currentService.getName() + e.getMessage()));
                    log.info((Object)"Throttling will occur using default module policy");
                    throttle = defaultThrottle;
                }
                if (throttle != null) {
                    HashMap<String, Throttle> throttles = (HashMap<String, Throttle>)configctx.getPropertyNonReplicable("local_throttle_map");
                    if (throttles == null) {
                        throttles = new HashMap<String, Throttle>();
                        configctx.setNonReplicableProperty("local_throttle_map", throttles);
                    }
                    String serviceName = currentService.getName();
                    throttle.setId(serviceName);
                    throttles.put(serviceName, throttle);
                    ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                    if (cac != null) {
                        String cacKey = "throttle_" + serviceName + "_cac_key";
                        configctx.setProperty(cacKey, (Object)cac);
                    }
                }
            }
        } else if (axisDescription instanceof AxisOperation) {
            Throttle throttle = null;
            AxisOperation currentOperation = (AxisOperation)axisDescription;
            AxisService axisService = (AxisService)currentOperation.getParent();
            if (axisService != null) {
                String currentServiceName = axisService.getName();
                PolicySubject policySubject = currentOperation.getPolicySubject();
                if (policySubject != null) {
                    QName opQName;
                    HashMap<String, Throttle> throttles;
                    try {
                        ArrayList policies = new ArrayList(policySubject.getAttachedPolicyComponents());
                        Policy currentPolicy = PolicyUtil.getMergedPolicy(policies, (AxisDescription)currentOperation);
                        if (currentPolicy != null) {
                            throttle = ThrottleFactory.createOperationThrottle(currentPolicy);
                        }
                    }
                    catch (ThrottleException e) {
                        log.error((Object)("Error was occurred when engaging throttle module for operation : " + currentOperation.getName() + " in the service :" + currentServiceName + e.getMessage()));
                        log.info((Object)"Throttling will occur using default module policy");
                    }
                    if (throttle == null) {
                        throttle = defaultThrottle;
                    }
                    if ((throttles = (HashMap<String, Throttle>)configctx.getPropertyNonReplicable("local_throttle_map")) == null) {
                        throttles = new HashMap<String, Throttle>();
                        configctx.setNonReplicableProperty("local_throttle_map", throttles);
                    }
                    if ((opQName = currentOperation.getName()) != null) {
                        String opName = opQName.getLocalPart();
                        String key = currentServiceName + opName;
                        throttle.setId(key);
                        throttles.put(key, throttle);
                        ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                        if (cac != null) {
                            String cacKey = "throttle_" + key + "_cac_key";
                            configctx.setProperty(cacKey, (Object)cac);
                        }
                    }
                }
            }
        }
    }

    private static Policy getThrottlePolicy(Collection components) throws AxisFault {
        for (Object comp : components) {
            Policy policy = (Policy)comp;
            Iterator iterator = policy.getAlternatives();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Object assertObj : list) {
                    XmlPrimtiveAssertion primitiveAssertion;
                    QName assertionName;
                    if (!(assertObj instanceof XmlPrimtiveAssertion) || !(assertionName = (primitiveAssertion = (XmlPrimtiveAssertion)assertObj).getName()).equals(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Existing ThrottleAssertion found");
                    }
                    return policy;
                }
            }
        }
        return null;
    }

    public static boolean isFilteredOutService(AxisServiceGroup axisServiceGroup) {
        String adminParamValue = (String)axisServiceGroup.getParameterValue("adminService");
        String hiddenParamValue = (String)axisServiceGroup.getParameterValue("hiddenService");
        String dynamicParamValue = (String)axisServiceGroup.getParameterValue("dynamicService");
        return adminParamValue != null && adminParamValue.length() != 0 ? Boolean.parseBoolean(adminParamValue.trim()) : (hiddenParamValue != null && hiddenParamValue.length() != 0 ? Boolean.parseBoolean(hiddenParamValue.trim()) : dynamicParamValue != null && dynamicParamValue.length() != 0 && Boolean.parseBoolean(dynamicParamValue.trim()));
    }

    public static PolicySubject readExternalGlobalPolicy(AxisConfiguration axisConfig) {
        String policyPath;
        File policyFile;
        PolicySubject extPolicySubject = null;
        Parameter globalThrottlePolicyParam = axisConfig.getParameter("globalThrottlePolicyPath");
        if (globalThrottlePolicyParam != null && !"".equals(globalThrottlePolicyParam.getValue()) && (policyFile = new File(policyPath = (String)globalThrottlePolicyParam.getValue())).exists()) {
            try {
                Policy globalPolicy = PolicyEngine.getPolicy((InputStream)new FileInputStream(policyFile));
                extPolicySubject = new PolicySubject();
                extPolicySubject.attachPolicy(globalPolicy);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Error while reading global policy file..", (Throwable)e);
            }
        }
        return extPolicySubject;
    }
}

