/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class);
    private static String OAUTH_HEADER_SPLITTER = ",";
    private static String OAUTH_CONSUMER_KEY = "oauth_consumer_key";

    public static boolean isIpInRange(String address, String range) throws UnknownHostException {
        if (address == null || range == null) {
            return false;
        }
        String[] bounds = range.split("-");
        String ipLow = bounds[0].trim();
        String ipHigh = bounds[1].trim();
        long ipLo = Utils.ipToLong(InetAddress.getByName(ipLow));
        long ipHi = Utils.ipToLong(InetAddress.getByName(ipHigh));
        long ipToTest = Utils.ipToLong(InetAddress.getByName(address));
        return ipToTest >= ipLo && ipToTest <= ipHi;
    }

    public static String extractCustomerKeyFromAuthHeader(String authHeader) {
        String[] headers;
        String consumerKey = null;
        if (authHeader.startsWith("OAuth ") || authHeader.startsWith("oauth ")) {
            authHeader = authHeader.substring(authHeader.indexOf("o"));
        }
        if ((headers = authHeader.split(OAUTH_HEADER_SPLITTER)) != null && headers.length > 0) {
            for (int i = 0; i < headers.length; ++i) {
                String[] elements = headers[i].split("=");
                if (elements == null || elements.length <= 1 || !OAUTH_CONSUMER_KEY.equals(elements[0].trim())) continue;
                consumerKey = Utils.removeLeadingAndTrailing(elements[1].trim());
            }
        }
        return consumerKey;
    }

    private static String removeLeadingAndTrailing(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    private static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    public static void main(String[] args) throws UnknownHostException {
        System.out.println(Utils.isIpInRange("192.168.1.1", "192.168.1.1-192.168.1.10"));
        System.out.println(Utils.isIpInRange("192.168.1.4", "192.168.1.1-192.168.1.10"));
        System.out.println(Utils.isIpInRange("192.164.1.10", "192.168.1.1-192.168.1.10"));
        System.out.println(Utils.isIpInRange("193.168.1.1", "192.168.1.1-192.168.1.10"));
        System.out.println(Utils.extractCustomerKeyFromAuthHeader("oauth_consumer_key=\"nq21LN39VlKe6OezcOndBx\", oauth_signature_method=\"HMAC-SHA1\", oauth_signature=\"DZKyT75hiOIdtMGCU%2BbITArs4sU%3D\", oauth_timestamp=\"1328590467\", oauth_nonce=\"7031216264696\", oauth_version=\"1.0\""));
    }
}

