/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.theme.mgt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.theme.mgt.util.ThemeUtil;

public class ThemeLoadingListener
implements TenantMgtListener {
    private static final Log log = LogFactory.getLog(ThemeLoadingListener.class);
    private static final int EXEC_ORDER = 10;

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            ThemeUtil.loadTheme(tenantInfo.getTenantId());
        }
        catch (RegistryException e) {
            String msg = "Error in loading the theme for the tenant: " + tenantInfo.getTenantDomain() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfo) throws StratosException {
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public int getListenerOrder() {
        return 10;
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
    }

    public void onTenantActivation(int tenantId) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
    }

    public void onSubscriptionPlanChange(int tenentId, String oldPlan, String newPlan) throws StratosException {
    }
}

