/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.persistence.TenantPersistor;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.beans.PaginatedTenantInfoBean;
import org.wso2.carbon.tenant.mgt.core.internal.TenantMgtCoreServiceComponent;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TenantMgtAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(TenantMgtAdminService.class);

    public String addTenant(TenantInfoBean tenantInfoBean) throws Exception {
        try {
            CommonUtil.validateEmail((String)tenantInfoBean.getEmail());
        }
        catch (Exception e) {
            String msg = "Invalid email is provided.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String tenantDomain = tenantInfoBean.getTenantDomain();
        TenantMgtUtil.validateDomain(tenantDomain);
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceRegistry();
        if (userRegistry == null) {
            log.error((Object)"Security Alert! User registry is null. A user is trying create a tenant  without an authenticated session.");
            throw new Exception("Invalid data.");
        }
        if (userRegistry.getTenantId() != -1234) {
            log.error((Object)"Security Alert! Non super tenant trying to create a tenant.");
            throw new Exception("Invalid data.");
        }
        org.wso2.carbon.user.core.tenant.Tenant tenant = TenantMgtUtil.initializeTenant(tenantInfoBean);
        TenantPersistor persistor = TenantMgtServiceComponent.getTenantPersistor();
        int tenantId = persistor.persistTenant(tenant, false, tenantInfoBean.getSuccessKey(), tenantInfoBean.getOriginatedService());
        tenantInfoBean.setTenantId(tenantId);
        TenantMgtUtil.addClaimsToUserStoreManager(tenant);
        try {
            TenantMgtUtil.triggerAddTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant addition.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        TenantMgtUtil.activateTenantInitially(tenantInfoBean, tenantId);
        return TenantMgtUtil.prepareStringToShowThemeMgtPage(tenant.getId());
    }

    private List<TenantInfoBean> getAllTenants() throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant[] tenants;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenants = (org.wso2.carbon.user.core.tenant.Tenant[])tenantManager.getAllTenants();
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        ArrayList<TenantInfoBean> tenantList = new ArrayList<TenantInfoBean>();
        for (org.wso2.carbon.user.core.tenant.Tenant tenant : tenants) {
            TenantInfoBean bean = TenantMgtUtil.getTenantInfoBeanfromTenant(tenant.getId(), tenant);
            tenantList.add(bean);
        }
        return tenantList;
    }

    public TenantInfoBean[] retrieveTenants() throws Exception {
        List<TenantInfoBean> tenantList = this.getAllTenants();
        return tenantList.toArray(new TenantInfoBean[tenantList.size()]);
    }

    public PaginatedTenantInfoBean retrievePaginatedTenants(int pageNumber) throws Exception {
        List<TenantInfoBean> tenantList = this.getAllTenants();
        PaginatedTenantInfoBean paginatedTenantInfoBean = new PaginatedTenantInfoBean();
        DataPaginator.doPaging((int)pageNumber, tenantList, (Pageable)paginatedTenantInfoBean);
        return paginatedTenantInfoBean;
    }

    public TenantInfoBean getTenant(String tenantDomain) throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant tenant;
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
        try {
            tenant = (org.wso2.carbon.user.core.tenant.Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant from the tenant manager.";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
        TenantInfoBean bean = TenantMgtUtil.initializeTenantInfoBean(tenantId, tenant);
        bean.setFirstname(ClaimsMgtUtil.getFirstNamefromUserStoreManager((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
        bean.setLastname(ClaimsMgtUtil.getLastNamefromUserStoreManager((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
        String activePlan = "";
        if (TenantMgtServiceComponent.getBillingService() != null) {
            activePlan = TenantMgtServiceComponent.getBillingService().getActiveUsagePlan(tenantDomain);
        }
        if (activePlan != null && activePlan.trim().length() > 0) {
            bean.setUsagePlan(activePlan);
        } else {
            bean.setUsagePlan("");
        }
        return bean;
    }

    public void updateTenant(TenantInfoBean tenantInfoBean) throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant tenant;
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        UserRegistry configSystemRegistry = TenantMgtServiceComponent.getConfigSystemRegistry(tenantInfoBean.getTenantId());
        String tenantDomain = tenantInfoBean.getTenantDomain();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            tenant = (org.wso2.carbon.user.core.tenant.Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        if (tenantInfoBean.getFirstname() != null && !tenantInfoBean.getFirstname().trim().equals("")) {
            try {
                CommonUtil.validateName((String)tenantInfoBean.getFirstname(), (String)"First Name");
            }
            catch (Exception e) {
                String msg = "Invalid first name is provided.";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        if (tenantInfoBean.getLastname() != null && !tenantInfoBean.getLastname().trim().equals("")) {
            try {
                CommonUtil.validateName((String)tenantInfoBean.getLastname(), (String)"Last Name");
            }
            catch (Exception e) {
                String msg = "Invalid last name is provided.";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        HashMap<String, String> claimsMap = new HashMap<String, String>();
        claimsMap.put("http://wso2.org/claims/givenname", tenantInfoBean.getFirstname());
        claimsMap.put("http://wso2.org/claims/lastname", tenantInfoBean.getLastname());
        UserStoreManager userStoreManager = TenantMgtUtil.getUserStoreManager(tenant, tenant.getId());
        userStoreManager.setUserClaimValues(tenantInfoBean.getAdmin(), claimsMap, "default");
        if (tenantInfoBean.getEmail() != null && !tenantInfoBean.getEmail().equals("")) {
            try {
                CommonUtil.validateEmail((String)tenantInfoBean.getEmail());
            }
            catch (Exception e) {
                String msg = "Invalid email is provided.";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
            tenant.setEmail(tenantInfoBean.getEmail());
        }
        UserRealm userRealm = configSystemRegistry.getUserRealm();
        try {
            userStoreManager = userRealm.getUserStoreManager();
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the user store manager for tenant, tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        boolean updatePassword = false;
        if (tenantInfoBean.getAdminPassword() != null && !tenantInfoBean.getAdminPassword().equals("")) {
            updatePassword = true;
        }
        if (!userStoreManager.isReadOnly() && updatePassword) {
            try {
                userStoreManager.updateCredentialByAdmin(tenantInfoBean.getAdmin(), (Object)tenantInfoBean.getAdminPassword());
            }
            catch (UserStoreException e) {
                String msg = "Error in changing the tenant admin password, tenant domain: " + tenantInfoBean.getTenantDomain() + ". " + e.getMessage() + " for: " + tenantInfoBean.getAdmin();
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        } else {
            tenantInfoBean.setAdminPassword("");
        }
        try {
            tenantManager.updateTenant((Tenant)tenant);
        }
        catch (UserStoreException e) {
            String msg = "Error in updating the tenant for tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            TenantMgtUtil.triggerUpdateTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant update.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void activateTenant(String tenantDomain) throws Exception {
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        TenantMgtUtil.activateTenant(tenantDomain, tenantManager, tenantId);
        try {
            TenantMgtUtil.triggerTenantActivation(tenantId);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant activate.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void deactivateTenant(String tenantDomain) throws Exception {
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        TenantMgtUtil.deactivateTenant(tenantDomain, tenantManager, tenantId);
        try {
            TenantMgtUtil.triggerTenantDeactivation(tenantId);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant deactivate.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void deleteTenant(String tenantDomain) throws Exception {
        TenantManager tenantManager = TenantMgtCoreServiceComponent.getTenantManager();
        int tenantId = tenantManager.getTenantId(tenantDomain);
        try {
            TenantMgtServiceComponent.getBillingService().deleteBillingData(tenantId);
            TenantMgtUtil.deleteTenantRegistryData(tenantId);
            TenantMgtUtil.deleteTenantUMData(tenantId);
            tenantManager.deleteTenant(tenantId);
            log.info((Object)("Deleted tenant with domain: " + tenantDomain + " and tenant id: " + tenantId + " from the system."));
        }
        catch (Exception e) {
            String msg = "Error deleting tenant with domain: " + tenantDomain + " and tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

