/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.util.TenantRegistryDataDeletionUtil;
import org.wso2.carbon.tenant.mgt.util.TenantUMDataDeletionUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantMgtUtil {
    private static final Log log = LogFactory.getLog(TenantMgtUtil.class);
    private static final String ILLEGAL_CHARACTERS_FOR_TENANT_DOMAIN = ".*[^a-zA-Z0-9\\._\\-].*";

    public static String prepareStringToShowThemeMgtPage(int tenantId) throws RegistryException {
        UserRegistry systemRegistry = TenantMgtServiceComponent.getRegistryService().getGovernanceSystemRegistry();
        String uuid = UUIDGenerator.generateUUID();
        Resource resource = systemRegistry.newResource();
        String tenantIdStr = Integer.toString(tenantId);
        resource.setProperty("tenantId", tenantIdStr);
        String uuidPath = "/repository/components/org.wso2.carbon.theme-page-token/" + uuid;
        systemRegistry.put(uuidPath, resource);
        CommonUtil.denyAnonAuthorization((String)uuidPath, (UserRealm)systemRegistry.getUserRealm());
        return uuid;
    }

    public static void triggerAddTenant(TenantInfoBean tenantInfo) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantCreate(tenantInfo);
        }
    }

    public static void triggerUpdateTenant(TenantInfoBean tenantInfoBean) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantUpdate(tenantInfoBean);
        }
    }

    public static void triggerTenantInitialActivation(TenantInfoBean tenantInfoBean) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantInitialActivation(tenantInfoBean.getTenantId());
        }
    }

    public static void triggerTenantActivation(int tenantId) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantActivation(tenantId);
        }
    }

    public static void triggerTenantDeactivation(int tenantId) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantDeactivation(tenantId);
        }
    }

    public static void validateDomain(String domainName) throws Exception {
        int lastIndexOfDot;
        if (domainName == null || domainName.equals("")) {
            String msg = "Provided domain name is empty.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (CommonUtil.isPublicCloudSetup() && (lastIndexOfDot = domainName.lastIndexOf(".")) <= 0) {
            String msg = "You should have an extension to your domain.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int indexOfDot = domainName.indexOf(".");
        if (indexOfDot == 0) {
            String msg = "Invalid domain, starting with '.'";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (domainName.matches(ILLEGAL_CHARACTERS_FOR_TENANT_DOMAIN)) {
            String msg = "The tenant domain ' " + domainName + " ' contains one or more illegal characters. the valid characters are " + "letters, numbers, '.', '-' and '_'";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    public static UserStoreManager getUserStoreManager(Tenant tenant, int tenantId) throws Exception {
        UserRealm userRealm;
        RealmConfiguration realmConfig = TenantMgtServiceComponent.getBootstrapRealmConfiguration();
        TenantMgtConfiguration tenantMgtConfiguration = TenantMgtServiceComponent.getRealmService().getTenantMgtConfiguration();
        try {
            MultiTenantRealmConfigBuilder builder = TenantMgtServiceComponent.getRealmService().getMultiTenantRealmConfigBuilder();
            RealmConfiguration realmConfigToPersist = builder.getRealmConfigForTenantToPersist(realmConfig, tenantMgtConfiguration, tenant, tenantId);
            RealmConfiguration realmConfigToCreate = builder.getRealmConfigForTenantToCreateRealmOnTenantCreation(realmConfig, realmConfigToPersist, tenantId);
            userRealm = TenantMgtServiceComponent.getRealmService().getUserRealm(realmConfigToCreate);
        }
        catch (UserStoreException e) {
            String msg = "Error in creating Realm for tenant, tenant domain: " + tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            return userStoreManager;
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the userstore/authorization manager for tenant: " + tenant.getDomain();
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public static Tenant initializeTenant(TenantInfoBean tenantInfoBean) {
        Tenant tenant = new Tenant();
        tenant.setDomain(tenantInfoBean.getTenantDomain());
        tenant.setEmail(tenantInfoBean.getEmail());
        tenant.setAdminName(tenantInfoBean.getAdmin());
        tenant.setAdminFirstName(tenantInfoBean.getFirstname());
        tenant.setAdminLastName(tenantInfoBean.getLastname());
        tenant.setAdminPassword(tenantInfoBean.getAdminPassword());
        Calendar createdDateCal = tenantInfoBean.getCreatedDate();
        long createdDate = createdDateCal != null ? createdDateCal.getTimeInMillis() : System.currentTimeMillis();
        tenant.setCreatedDate(new Date(createdDate));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant object Initialized from the TenantInfoBean");
        }
        return tenant;
    }

    public static TenantInfoBean initializeTenantInfoBean(int tenantId, Tenant tenant) throws Exception {
        TenantInfoBean bean = TenantMgtUtil.getTenantInfoBeanfromTenant(tenantId, tenant);
        if (tenant != null) {
            bean.setAdmin(ClaimsMgtUtil.getAdminUserNameFromTenantId((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
        }
        return bean;
    }

    public static TenantInfoBean getTenantInfoBeanfromTenant(int tenantId, Tenant tenant) {
        TenantInfoBean bean = new TenantInfoBean();
        if (tenant != null) {
            bean.setTenantId(tenantId);
            bean.setTenantDomain(tenant.getDomain());
            bean.setEmail(tenant.getEmail());
            Calendar createdDate = Calendar.getInstance();
            createdDate.setTimeInMillis(tenant.getCreatedDate().getTime());
            bean.setCreatedDate(createdDate);
            bean.setActive(tenant.isActive());
            if (log.isDebugEnabled()) {
                log.debug((Object)"The TenantInfoBean object has been created from the tenant.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The tenant is null.");
        }
        return bean;
    }

    public static void addClaimsToUserStoreManager(Tenant tenant) throws Exception {
        try {
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            claimsMap.put("http://wso2.org/claims/givenname", tenant.getAdminFirstName());
            claimsMap.put("http://wso2.org/claims/lastname", tenant.getAdminLastName());
            UserStoreManager userStoreManager = (UserStoreManager)TenantMgtServiceComponent.getRealmService().getTenantUserRealm(tenant.getId()).getUserStoreManager();
            userStoreManager.setUserClaimValues(tenant.getAdminName(), claimsMap, "default");
        }
        catch (Exception e) {
            String msg = "Error in adding claims to the user.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void activateTenantInitially(TenantInfoBean tenantInfoBean, int tenantId) throws Exception {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        String tenantDomain = tenantInfoBean.getTenantDomain();
        TenantMgtUtil.activateTenant(tenantDomain, tenantManager, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activated the tenant " + tenantDomain + " at the time of tenant creation"));
        }
        try {
            TenantMgtUtil.triggerTenantInitialActivation(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant initial activation.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void activateTenant(String tenantDomain, TenantManager tenantManager, int tenantId) throws Exception {
        try {
            tenantManager.activateTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in activating the tenant for tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            if (TenantMgtServiceComponent.getBillingService() != null) {
                TenantMgtServiceComponent.getBillingService().activateUsagePlan(tenantDomain);
            }
        }
        catch (Exception e) {
            String msg = "Error while activating subscription for domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void deactivateTenant(String tenantDomain, TenantManager tenantManager, int tenantId) throws Exception {
        try {
            tenantManager.deactivateTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in deactivating tenant for tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void deleteTenantRegistryData(int tenantId) throws Exception {
        JDBCDataAccessManager configMgr = (JDBCDataAccessManager)TenantMgtServiceComponent.getRegistryService().getConfigUserRegistry().getRegistryContext().getDataAccessManager();
        TenantRegistryDataDeletionUtil.deleteTenantRegistryData(tenantId, configMgr.getDataSource().getConnection());
        JDBCDataAccessManager govMgr = (JDBCDataAccessManager)TenantMgtServiceComponent.getRegistryService().getGovernanceUserRegistry().getRegistryContext().getDataAccessManager();
        TenantRegistryDataDeletionUtil.deleteTenantRegistryData(tenantId, govMgr.getDataSource().getConnection());
    }

    public static void deleteTenantUMData(int tenantId) throws Exception {
        RealmConfiguration realmConfig = TenantMgtServiceComponent.getRealmService().getBootstrapRealmConfiguration();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(realmConfig.getRealmProperty("driverName"));
        dataSource.setUrl(realmConfig.getRealmProperty("url"));
        dataSource.setUsername(realmConfig.getRealmProperty("userName"));
        dataSource.setPassword(realmConfig.getRealmProperty("password"));
        dataSource.setMaxActive(Integer.parseInt(realmConfig.getRealmProperty("maxActive")));
        dataSource.setMinIdle(Integer.parseInt(realmConfig.getRealmProperty("minIdle")));
        dataSource.setMaxWait((long)Integer.parseInt(realmConfig.getRealmProperty("maxWait")));
        TenantUMDataDeletionUtil.deleteTenantUMData(tenantId, dataSource.getConnection());
    }
}

