/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.service.TaskManagementService;
import org.wso2.carbon.task.ServiceHanlder;
import org.wso2.carbon.task.TaskManager;

public class TaskManagementServiceHandler
extends ServiceHanlder {
    private static final Log log = LogFactory.getLog(TaskManager.class);

    public void addTaskDescription(TaskDescription taskDescription, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        if (managementService != null) {
            managementService.addTaskDescription(taskDescription);
        }
    }

    public void deleteTaskDescription(String name, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        if (managementService != null) {
            managementService.deleteTaskDescription(name);
        }
    }

    public void editTaskDescription(TaskDescription taskDescription, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        if (managementService != null) {
            managementService.editTaskDescription(taskDescription);
        }
    }

    public TaskDescription getTaskDescription(String name, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        if (managementService != null) {
            return managementService.getTaskDescription(name);
        }
        return null;
    }

    public boolean isContains(String name, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        return managementService != null && managementService.isContains(name);
    }

    public List<String> getPropertyNames(String taskClass, String className) {
        TaskManagementService managementService = this.getTaskManagementServiceImplementer(className);
        if (managementService != null) {
            return managementService.getPropertyNames(taskClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot find a property name list of class : " + taskClass));
        }
        return new ArrayList<String>();
    }

    public TaskManagementService getTaskManagementServiceImplementer(String className) {
        List<Object> services = this.getServices();
        if (!this.assertEmpty(services)) {
            for (Object serviceObject : services) {
                String name;
                if (!(serviceObject instanceof TaskManagementService) || !(name = serviceObject.getClass().getName()).equals(className)) continue;
                return (TaskManagementService)serviceObject;
            }
        }
        return null;
    }
}

