/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.service.TaskManagementService;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.task.JobMetaDataProviderServiceHandler;
import org.wso2.carbon.task.TaskManagementServiceHandler;
import org.wso2.carbon.task.TaskManager;
import org.wso2.carbon.task.multitenancy.TenantCreationListener;
import org.wso2.carbon.task.services.JobMetaDataProviderService;
import org.wso2.carbon.task.services.TaskDescriptionRepositoryService;
import org.wso2.carbon.task.util.ConfigHolder;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class TaskManagementServiceComponent {
    private static final Log log = LogFactory.getLog(TaskManagementServiceComponent.class);
    private ConfigurationContextService configCtxSvc;
    private final JobMetaDataProviderServiceHandler jobMetaDataProviderServiceHandler = new JobMetaDataProviderServiceHandler();
    private final TaskManagementServiceHandler taskManagementServiceHandler = new TaskManagementServiceHandler();
    private TaskDescriptionRepositoryService repositoryService;

    protected void activate(ComponentContext ctxt) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initiating a TaskManager");
            }
            ConfigHolder.getInstance().setJobMetaDataProviderServiceHandler(this.jobMetaDataProviderServiceHandler);
            ConfigHolder.getInstance().setTaskManagementServiceHandler(this.taskManagementServiceHandler);
            TenantCreationListener listener = new TenantCreationListener();
            ctxt.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)listener, null);
            TaskManager taskManager = new TaskManager();
            taskManager.setTaskDescriptionRepository(this.repositoryService.getTaskDescriptionRepository());
            taskManager.init(this.jobMetaDataProviderServiceHandler, this.taskManagementServiceHandler);
            this.configCtxSvc.getServerConfigContext().setProperty("CARBON_TASK_MANAGER", (Object)taskManager);
            this.configCtxSvc.getServerConfigContext().setProperty("CARBON_TASK_REPOSITORY", (Object)this.repositoryService.getTaskDescriptionRepository());
            this.configCtxSvc.getServerConfigContext().setProperty("CARBON_TASK_JOB_METADATA_SERVICE", (Object)this.jobMetaDataProviderServiceHandler);
            this.configCtxSvc.getServerConfigContext().setProperty("CARBON_TASK_MANAGEMENT_SERVICE", (Object)this.taskManagementServiceHandler);
        }
        catch (Throwable t) {
            log.fatal((Object)"Error occured while initializing task management", t);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setJobMetaDataProviderService(JobMetaDataProviderService jobMetaDataProviderService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding a JobMetaDataProviderService");
        }
        this.jobMetaDataProviderServiceHandler.addService(jobMetaDataProviderService);
    }

    protected void unsetJobMetaDataProviderService(JobMetaDataProviderService jobMetaDataProviderService) {
        this.jobMetaDataProviderServiceHandler.removeService(jobMetaDataProviderService);
    }

    protected void setTaskManagementService(TaskManagementService taskManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding a TaskManagementService");
        }
        this.taskManagementServiceHandler.addService(taskManagementService);
    }

    protected void unsetTaskManagementService(TaskManagementService taskManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing a TaskManagementService");
        }
        this.taskManagementServiceHandler.removeService(taskManagementService);
    }

    protected void setTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskDescriptionRepositoryService  bound to the ESB initialization process");
        }
        this.repositoryService = repositoryService;
    }

    protected void unsetTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskDescriptionRepositoryService  unbound from the ESB environment");
        }
        this.repositoryService = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the ESB initialization process");
        }
        this.configCtxSvc = configurationContextService;
        ConfigHolder.getInstance().setConfigCtxSvc(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the ESB environment");
        }
        this.configCtxSvc = null;
        ConfigHolder.getInstance().setConfigCtxSvc(null);
    }
}

