/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sts.STSDeploymentInterceptor;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;

public class STSServiceComponent {
    private static Log log = LogFactory.getLog(STSServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is activated");
        }
        try {
            Properties props = new Properties();
            props.put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
            ctxt.getBundleContext().registerService(AxisObserver.class.getName(), (Object)new STSDeploymentInterceptor(), (Dictionary)props);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while updating carbon STS service", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Carbon STS bundle");
        }
        try {
            STSServiceDataHolder.getInstance().setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        STSServiceDataHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Carbon STS bundle");
        }
    }
}

