/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.deployment.DeploymentInterceptor;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.security.util.RampartConfigUtil;
import org.wso2.carbon.security.util.ServerCrypto;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;

public class STSDeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(DeploymentInterceptor.class);

    public void serviceUpdate(AxisEvent event, AxisService service) {
        if (event.getEventType() == 1 && "wso2carbon-sts".equals(service.getName())) {
            try {
                STSDeploymentInterceptor.updateSTSService(service.getAxisConfiguration());
            }
            catch (Exception e) {
                log.error((Object)"Error while updating wso2carbon-sts in STSDeploymentInterceptor", (Throwable)e);
            }
        }
    }

    public static void updateSTSService(AxisConfiguration config) throws Exception {
        AxisService service = null;
        UserRegistry configRegistry = null;
        UserRegistry governRegistry = null;
        String keyAlias = null;
        String keyPassword = null;
        KeyStoreAdmin admin = null;
        KeyStoreData[] keystores = null;
        String privateKeyAlias = null;
        String keyStoreName = null;
        String issuerName = null;
        ServerConfiguration serverConfig = null;
        configRegistry = STSServiceDataHolder.getInstance().getRegistryService().getConfigSystemRegistry();
        governRegistry = STSServiceDataHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
        if (configRegistry == null || config.getService("wso2carbon-sts") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"configRegistry not set or STS service is unavailable");
            }
            return;
        }
        serverConfig = ServerConfiguration.getInstance();
        keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        keyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
        issuerName = serverConfig.getFirstProperty("HostName");
        if (issuerName == null) {
            issuerName = "wso2carbon-sts";
        }
        admin = new KeyStoreAdmin(-1234, (Registry)governRegistry);
        keystores = admin.getKeyStores(true);
        for (int i = 0; i < keystores.length; ++i) {
            if (!KeyStoreUtil.isPrimaryStore((String)keystores[i].getKeyStoreName())) continue;
            keyStoreName = keystores[i].getKeyStoreName();
            privateKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)KeyStoreManager.getInstance((int)-1234).getKeyStore(keyStoreName));
            break;
        }
        if (privateKeyAlias != null) {
            String tokenStoreDisabled;
            String ttl;
            service = config.getService("wso2carbon-sts");
            String cryptoProvider = ServerCrypto.class.getName();
            Properties props = RampartConfigUtil.getServerCryptoProperties((String[])new String[]{keyStoreName}, (String)keyStoreName, (String)privateKeyAlias);
            SAMLTokenIssuerConfig stsSamlConfig = new SAMLTokenIssuerConfig(issuerName, cryptoProvider, props);
            stsSamlConfig.setIssuerKeyAlias(keyAlias);
            stsSamlConfig.setIssuerKeyPassword(keyPassword);
            stsSamlConfig.setAddRequestedAttachedRef(true);
            stsSamlConfig.setAddRequestedUnattachedRef(true);
            stsSamlConfig.setKeyComputation(2);
            stsSamlConfig.setProofKeyType("BinarySecret");
            String resourcePath = null;
            resourcePath = "/repository/axis2/service-groups/wso2carbon-sts/services/wso2carbon-sts/trustedServices";
            if (configRegistry.resourceExists(resourcePath)) {
                Resource trustedService = null;
                Properties properties = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                trustedService = configRegistry.get(resourcePath);
                properties = trustedService.getProperties();
                if (properties != null && !properties.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        stsSamlConfig.addTrustedServiceEndpointAddress((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                    }
                }
            }
            if ((ttl = serverConfig.getFirstProperty("STSTimeToLive")) != null && ttl.length() > 0) {
                try {
                    stsSamlConfig.setTtl(Long.parseLong(ttl));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("STSTimeToLive read from carbon.xml " + ttl));
                    }
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Error while reading STSTimeToLive from carbon.xml", (Throwable)e);
                }
            }
            if ((tokenStoreDisabled = serverConfig.getFirstProperty("Security.DisableTokenStore")) != null) {
                stsSamlConfig.setTokenStoreDisabled(Boolean.parseBoolean(tokenStoreDisabled));
            }
            String persisterClassName = serverConfig.getFirstProperty("Security.TokenPersister.Class");
            String persistingFilePath = serverConfig.getFirstProperty("Security.TokenPersister.StoragePath");
            String inMemoryThreshold = serverConfig.getFirstProperty("Security.TokenPersister.InMemoryThreshold");
            if (persisterClassName != null) {
                stsSamlConfig.setPersisterClassName(persisterClassName);
            }
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            if (persistingFilePath != null) {
                propertyMap.put("StoragePath", persistingFilePath);
            }
            if (inMemoryThreshold != null) {
                propertyMap.put("InMemoryThreshold", inMemoryThreshold);
            }
            if (log.isDebugEnabled() && persisterClassName != null && inMemoryThreshold == null) {
                log.debug((Object)"Although persister is defined, threshold not defined.");
            }
            String[] persisterPropertyNames = serverConfig.getProperties("Security.TokenPersister.Properties.Property.Name");
            String[] persisterPropertyValues = serverConfig.getProperties("Security.TokenPersister.Properties.Property.Value");
            if (persisterPropertyNames.length != 0 && persisterPropertyValues.length != 0 && persisterPropertyNames.length == persisterPropertyValues.length) {
                for (int i = 0; i < persisterPropertyNames.length; ++i) {
                    propertyMap.put(persisterPropertyNames[i], persisterPropertyValues[i]);
                }
            }
            if (propertyMap.size() != 0) {
                stsSamlConfig.setPersisterPropertyMap(propertyMap);
            }
            try {
                Parameter param = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                if (param == null) {
                    service.addParameter(stsSamlConfig.getParameter());
                }
            }
            catch (AxisFault e) {
                log.error((Object)"Error while updating wso2carbon-sts in STSDeploymentInterceptor", (Throwable)e);
            }
        }
    }

    public void init(AxisConfiguration arg0) {
    }

    public void moduleUpdate(AxisEvent arg0, AxisModule arg1) {
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup group) {
    }

    public void addParameter(Parameter arg0) throws AxisFault {
    }

    public void deserializeParameters(OMElement arg0) throws AxisFault {
    }

    public Parameter getParameter(String arg0) {
        return null;
    }

    public ArrayList getParameters() {
        return null;
    }

    public boolean isParameterLocked(String arg0) {
        return false;
    }

    public void removeParameter(Parameter arg0) throws AxisFault {
    }
}

