/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.summary.generator.internal;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.core.summary.generators.SummaryGeneratorFactory;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.usage.summary.generator.MeteringSummaryGeneratorFactory;
import org.wso2.carbon.usage.summary.generator.RegistryUsageSummaryGeneratorTask;
import org.wso2.carbon.usage.summary.generator.client.UsageSummaryGeneratorClient;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class UsageSummaryGeneratorServiceComponent {
    private static Log log = LogFactory.getLog(UsageSummaryGeneratorServiceComponent.class);
    private static ConfigurationContextService configurationContextService;
    private static RealmService realmService;
    public static final long DEFAULT_INITIAL_SUMMARY_GEN_DELAY = 600000L;
    public static final long DEFAULT_SUMMARY_GEN_INTERVAL = 86400000L;

    protected void activate(ComponentContext context) {
        try {
            StratosConfiguration stratosConfigurations = CommonUtil.getStratosConfig();
            if (!stratosConfigurations.isSkipSummaryGenerator()) {
                UsageSummaryGeneratorClient client = new UsageSummaryGeneratorClient(configurationContextService.getServerConfigContext());
                MeteringSummaryGeneratorFactory summaryGeneratorFactory = new MeteringSummaryGeneratorFactory(client);
                context.getBundleContext().registerService(SummaryGeneratorFactory.class.getName(), (Object)summaryGeneratorFactory, null);
                RegistryUsageSummaryGeneratorTask regUsageSummaryGeneratorTask = new RegistryUsageSummaryGeneratorTask(client, realmService);
                Timer summaryTimer = new Timer(true);
                summaryTimer.schedule((TimerTask)regUsageSummaryGeneratorTask, 600000L, 86400000L);
                log.info((Object)"Stratos Usage Summary Generation Enabled.");
            } else {
                log.info((Object)"Stratos Usage Summary Generation Disabled.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"******* Error in activating Usage bundle ******* ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Usage Summary Generation bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService ccService) {
        configurationContextService = ccService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService ccService) {
        configurationContextService = null;
    }

    protected void setRealmService(RealmService realmService) {
        UsageSummaryGeneratorServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        realmService = null;
    }
}

