/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.summary.generator;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.beans.xsd.BandwidthHourlyStatValue;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.beans.xsd.BandwidthStatValue;
import org.wso2.carbon.usage.summary.generator.client.UsageSummaryGeneratorClient;

public class MeteringSummaryGenerator
extends AbstractSummaryGenerator {
    private static final Log log = LogFactory.getLog(MeteringSummaryGenerator.class);
    private ServerDO server;
    private UsageSummaryGeneratorClient client;

    public MeteringSummaryGenerator(ServerDO server, int timeInterval, UsageSummaryGeneratorClient client) {
        super(timeInterval);
        this.server = server;
        this.client = client;
    }

    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL();
    }

    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        return this.client.getLatestSummaryTime(this.getTimeInterval(), this.server.getId());
    }

    protected Calendar getLatestDailySummaryTime() throws BAMException {
        return this.client.getLatestSummaryTime(this.getTimeInterval(), this.server.getId());
    }

    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        return this.client.getLatestSummaryTime(this.getTimeInterval(), this.server.getId());
    }

    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        return this.client.getLatestSummaryTime(this.getTimeInterval(), this.server.getId());
    }

    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        return this.client.getLatestSummaryTime(this.getTimeInterval(), this.server.getId());
    }

    protected void summarizeHourly(BAMCalendar start, BAMCalendar end) {
        try {
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            HourDimension hd = spm.getHourDimension((Calendar)start);
            if (hd == null) {
                spm.addHourDimension(start);
                hd = spm.getHourDimension((Calendar)start);
            }
            BandwidthHourlyStatValue[] statValues = this.client.getStub().getDataForHourlySummary(this.server.getId(), "%Bandwidth%", (Calendar)start, (Calendar)end);
            BandwidthSummarizer summarizer = new BandwidthSummarizer(statValues);
            if (summarizer.regInBandwidth > 0L || summarizer.regOutBandwidth > 0L) {
                this.client.getStub().addBandwidthStatHourlySummary(this.server.getId(), hd.getId(), "RegistryBandwidth", summarizer.regInBandwidth, summarizer.regOutBandwidth);
            }
            if (summarizer.svcInBandwidth > 0L || summarizer.svcOutBandwidth > 0L) {
                this.client.getStub().addBandwidthStatHourlySummary(this.server.getId(), hd.getId(), "ServiceBandwidth", summarizer.svcInBandwidth, summarizer.svcOutBandwidth);
            }
            this.client.getStub().addBandwidthStatHourlySummary(this.server.getId(), hd.getId(), "WebappBandwidth", summarizer.webappInBandwidth, summarizer.webappOutBandwidth);
            TimeRange retention = BAMPersistenceManager.getPersistenceManager((Registry)BAMUtil.getRegistry()).getDataRetentionPeriod();
            if (retention != null && retention.getValue() != 0) {
                BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)start);
                BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)end);
                delHiHour.add(retention.getType(), -1 * retention.getValue());
                delLoHour.add(retention.getType(), -1 * retention.getValue());
                this.deleteServerUserData((Calendar)delLoHour, (Calendar)delHiHour);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while running hourly bandwidth summary generator for server " + this.server.getServerURL()), (Throwable)e);
        }
    }

    protected void summarizeDaily(BAMCalendar start, BAMCalendar end) {
        try {
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            DayDimension dd = spm.getDayDimension((Calendar)start);
            if (dd == null) {
                spm.addDayDimension(start);
                dd = spm.getDayDimension((Calendar)start);
            }
            BandwidthStatValue[] statValues = this.client.getStub().getDataForDailySummary(this.server.getId(), (Calendar)start, (Calendar)end);
            BandwidthSummarizer summarizer = new BandwidthSummarizer(statValues);
            if (summarizer.regInBandwidth > 0L || summarizer.regOutBandwidth > 0L) {
                this.client.getStub().addBandwidthStatDailySummary(this.server.getId(), dd.getId(), "RegistryBandwidth", summarizer.regInBandwidth, summarizer.regOutBandwidth);
            }
            if (summarizer.svcInBandwidth > 0L || summarizer.svcOutBandwidth > 0L) {
                this.client.getStub().addBandwidthStatDailySummary(this.server.getId(), dd.getId(), "ServiceBandwidth", summarizer.svcInBandwidth, summarizer.svcOutBandwidth);
            }
            this.client.getStub().addBandwidthStatDailySummary(this.server.getId(), dd.getId(), "WebappBandwidth", summarizer.webappInBandwidth, summarizer.webappOutBandwidth);
        }
        catch (Exception e) {
            log.error((Object)("Error while running daily bandwidth summary generator for server: " + this.server.getServerURL()), (Throwable)e);
        }
    }

    protected void summarizeMonthly(BAMCalendar start, BAMCalendar end) {
        try {
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            MonthDimension md = spm.getMonthDimension((Calendar)start);
            if (md == null) {
                spm.addMonthDimension(start);
                md = spm.getMonthDimension((Calendar)start);
            }
            BandwidthStatValue[] statValues = this.client.getStub().getDataForMonthlySummary(this.server.getId(), (Calendar)start, (Calendar)end);
            BandwidthSummarizer summarizer = new BandwidthSummarizer(statValues);
            this.client.getStub().addBandwidthStatMonthlySummary(this.server.getId(), md.getId(), "RegistryBandwidth", summarizer.regInBandwidth, summarizer.regOutBandwidth);
            this.client.getStub().addBandwidthStatMonthlySummary(this.server.getId(), md.getId(), "ServiceBandwidth", summarizer.svcInBandwidth, summarizer.svcOutBandwidth);
            this.client.getStub().addBandwidthStatMonthlySummary(this.server.getId(), md.getId(), "WebappBandwidth", summarizer.webappInBandwidth, summarizer.webappOutBandwidth);
        }
        catch (Exception e) {
            log.error((Object)("Error while running monthly bandwidth summary generator for server: " + this.server.getServerURL()), (Throwable)e);
        }
    }

    protected void summarizeQuarterly(BAMCalendar start, BAMCalendar end) {
        try {
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            QuarterDimension qd = spm.getQuarterDimension((Calendar)start);
            if (qd == null) {
                spm.addQuarterDimension(start);
                qd = spm.getQuarterDimension((Calendar)start);
            }
            BandwidthStatValue[] statValues = this.client.getStub().getDataForQuarterlySummary(this.server.getId(), (Calendar)start, (Calendar)end);
            BandwidthSummarizer summarizer = new BandwidthSummarizer(statValues);
            this.client.getStub().addBandwidthStatQuarterlySummary(this.server.getId(), qd.getId(), "RegistryBandwidth", summarizer.regInBandwidth, summarizer.regOutBandwidth);
            this.client.getStub().addBandwidthStatQuarterlySummary(this.server.getId(), qd.getId(), "ServiceBandwidth", summarizer.svcInBandwidth, summarizer.svcOutBandwidth);
            this.client.getStub().addBandwidthStatQuarterlySummary(this.server.getId(), qd.getId(), "WebappBandwidth", summarizer.webappInBandwidth, summarizer.webappOutBandwidth);
        }
        catch (Exception e) {
            log.error((Object)("Error while running quarterly bandwidth summary generator for server: " + this.server.getServerURL()), (Throwable)e);
        }
    }

    protected void summarizeYearly(BAMCalendar start, BAMCalendar end) {
        try {
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            YearDimension yd = spm.getYearDimension((Calendar)start);
            if (yd == null) {
                spm.addYearDimension(start);
                yd = spm.getYearDimension((Calendar)start);
            }
            BandwidthStatValue[] statValues = this.client.getStub().getDataForYearlySummary(this.server.getId(), (Calendar)start, (Calendar)end);
            BandwidthSummarizer summarizer = new BandwidthSummarizer(statValues);
            this.client.getStub().addBandwidthStatYearlySummary(this.server.getId(), yd.getId(), "RegistryBandwidth", summarizer.regInBandwidth, summarizer.regOutBandwidth);
            this.client.getStub().addBandwidthStatYearlySummary(this.server.getId(), yd.getId(), "ServiceBandwidth", summarizer.svcInBandwidth, summarizer.svcOutBandwidth);
            this.client.getStub().addBandwidthStatYearlySummary(this.server.getId(), yd.getId(), "WebappBandwidth", summarizer.webappInBandwidth, summarizer.webappOutBandwidth);
        }
        catch (Exception e) {
            log.error((Object)("Error while running yearly bandwidth summary generator for server: " + this.server.getServerURL()), (Throwable)e);
        }
    }

    private void deleteServerUserData(Calendar start, Calendar end) throws Exception {
        this.client.getStub().deleteServerUserData(this.server.getId(), "RegistryBandwidth-In", start, end);
        this.client.getStub().deleteServerUserData(this.server.getId(), "RegistryBandwidth-Out", start, end);
        this.client.getStub().deleteServerUserData(this.server.getId(), "ServiceBandwidth-In", start, end);
        this.client.getStub().deleteServerUserData(this.server.getId(), "ServiceBandwidth-Out", start, end);
        this.client.getStub().deleteServerUserData(this.server.getId(), "WebappBandwidth-In", start, end);
        this.client.getStub().deleteServerUserData(this.server.getId(), "WebappBandwidth-Out", start, end);
    }

    private class BandwidthSummarizer {
        long regInBandwidth;
        long regOutBandwidth;
        long svcInBandwidth;
        long svcOutBandwidth;
        long webappInBandwidth;
        long webappOutBandwidth;

        public BandwidthSummarizer(BandwidthHourlyStatValue[] statValues) {
            if (statValues != null) {
                for (BandwidthHourlyStatValue statValue : statValues) {
                    String keyName = statValue.getKeyName();
                    String keyValue = statValue.getKeyValue();
                    if (keyName == null || keyValue == null) continue;
                    long value = 0L;
                    try {
                        value = Long.parseLong(keyValue);
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("Unable to parse value to long. Key[" + keyName + "] and value [" + keyValue + "]"));
                        continue;
                    }
                    if (keyName.equals("RegistryBandwidth-In")) {
                        this.regInBandwidth += value;
                        continue;
                    }
                    if (keyName.equals("RegistryBandwidth-Out")) {
                        this.regOutBandwidth += value;
                        continue;
                    }
                    if (keyName.equals("ServiceBandwidth-In")) {
                        this.svcInBandwidth += value;
                        continue;
                    }
                    if (keyName.equals("ServiceBandwidth-Out")) {
                        this.svcOutBandwidth += value;
                        continue;
                    }
                    if (keyName.equals("WebappBandwidth-In")) {
                        this.webappInBandwidth += value;
                        continue;
                    }
                    if (keyName.equals("WebappBandwidth-Out")) {
                        this.webappOutBandwidth += value;
                        continue;
                    }
                    log.debug((Object)("Keyname doesn't match any known keys. Key[" + keyName + "] and value [" + keyValue + "]"));
                }
            }
        }

        public BandwidthSummarizer(BandwidthStatValue[] statValues) {
            if (statValues != null) {
                for (BandwidthStatValue statValue : statValues) {
                    String keyName = statValue.getKeyName();
                    if (keyName.equals("RegistryBandwidth")) {
                        this.regInBandwidth += statValue.getIncomingBandwidth();
                        this.regOutBandwidth += statValue.getOutgoingBandwidth();
                        continue;
                    }
                    if (keyName.equals("ServiceBandwidth")) {
                        this.svcInBandwidth += statValue.getIncomingBandwidth();
                        this.svcOutBandwidth += statValue.getOutgoingBandwidth();
                        continue;
                    }
                    if (keyName.equals("WebappBandwidth")) {
                        this.webappInBandwidth += statValue.getIncomingBandwidth();
                        this.webappOutBandwidth += statValue.getOutgoingBandwidth();
                        continue;
                    }
                    log.debug((Object)("Keyname doesn't match any known keys. Key[" + keyName + "]"));
                }
            }
        }
    }
}

