/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.ui.utils;

import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.usage.stub.beans.xsd.BandwidthStatistics;
import org.wso2.carbon.usage.stub.beans.xsd.InstanceUsageStatics;
import org.wso2.carbon.usage.stub.beans.xsd.PaginatedInstanceUsage;
import org.wso2.carbon.usage.stub.beans.xsd.PaginatedTenantUsageInfo;
import org.wso2.carbon.usage.stub.beans.xsd.TenantDataCapacity;
import org.wso2.carbon.usage.stub.beans.xsd.TenantUsage;
import org.wso2.carbon.usage.ui.clients.UsageServiceClient;

public class UsageUtil {
    private static final Log log = LogFactory.getLog(UsageUtil.class);
    private static long KB_LIMIT = 1024L;
    private static long MB_LIMIT = 0x100000L;
    private static long GB_LIMIT = 0x40000000L;
    private static long TB_LIMIT = 0x10000000000L;

    public static TenantUsage retrieveCurrentTenantUsage(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            String yearMonth = request.getParameter("year-month");
            if (yearMonth == null) {
                yearMonth = UsageUtil.getCurrentYearMonth();
            }
            return serviceClient.retrieveCurrentTenantUsage(yearMonth);
        }
        catch (Exception e) {
            String msg = "Failed to get current tenant usage.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static TenantUsage[] retrieveTenantUsages(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            String yearMonth = request.getParameter("year-month");
            if (yearMonth == null) {
                yearMonth = UsageUtil.getCurrentYearMonth();
            }
            return serviceClient.retrieveTenantUsages(yearMonth);
        }
        catch (Exception e) {
            String msg = "Failed to get all tenants usages.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static PaginatedTenantUsageInfo retrievePaginatedTenantUsages(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String requestedPage = request.getParameter("requestedPage");
        int pageNumber = 1;
        boolean numberOfPages = true;
        int entriesPerPage = 15;
        if (requestedPage != null && requestedPage.length() > 0) {
            pageNumber = new Integer(requestedPage);
        }
        try {
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            String yearMonth = request.getParameter("year-month");
            if (yearMonth == null) {
                yearMonth = UsageUtil.getCurrentYearMonth();
            }
            return serviceClient.retrievePaginatedTenantUsages(yearMonth, pageNumber, entriesPerPage);
        }
        catch (Exception e) {
            String msg = "Failed to get all tenants usages.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static TenantUsage retrieveTenantUsage(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            String tenantIdStr;
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            String yearMonth = request.getParameter("year-month");
            if (yearMonth == null) {
                yearMonth = UsageUtil.getCurrentYearMonth();
            }
            if ((tenantIdStr = request.getParameter("tenant-id")) == null) {
                tenantIdStr = "0";
            }
            return serviceClient.retrieveTenantUsage(yearMonth, Integer.parseInt(tenantIdStr));
        }
        catch (Exception e) {
            String msg = "Failed to get tenant usages.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String convertBytesToString(long storage) {
        if (storage < KB_LIMIT) {
            return storage + " Byte(s)";
        }
        if (storage < MB_LIMIT) {
            return storage / KB_LIMIT + " KByte(s)";
        }
        if (storage < GB_LIMIT) {
            return storage / MB_LIMIT + " MByte(s)";
        }
        if (storage < TB_LIMIT) {
            return storage / GB_LIMIT + " GByte(s)";
        }
        return storage / TB_LIMIT + " TByte(s)";
    }

    public static String getCurrentYearMonth() {
        Calendar calendar = Calendar.getInstance();
        return CommonUtil.getMonthString((Calendar)calendar);
    }

    public static String[] getYearMonths() {
        ArrayList<String> yearMonths = new ArrayList<String>();
        for (int i = 0; i > -100; --i) {
            String yearMonth = CommonUtil.getMonthString((int)i);
            yearMonths.add(yearMonth);
        }
        return yearMonths.toArray(new String[yearMonths.size()]);
    }

    public static String getCurrentDataStorage(TenantUsage usage) {
        TenantDataCapacity regData = usage.getRegistryCapacity();
        long currentData = 0L;
        if (regData != null) {
            currentData = regData.getRegistryContentCapacity();
        }
        return UsageUtil.convertBytesToString(currentData);
    }

    public static String getHistoryDataStorage(TenantUsage usage) {
        TenantDataCapacity historyData = usage.getRegistryCapacity();
        long currentData = 0L;
        if (historyData != null) {
            currentData = historyData.getRegistryContentHistoryCapacity();
        }
        return UsageUtil.convertBytesToString(currentData);
    }

    public static String getTotalDataStorage(TenantUsage usage) {
        TenantDataCapacity regData = usage.getRegistryCapacity();
        long totalDataStorage = 0L;
        if (regData != null) {
            totalDataStorage = regData.getRegistryContentCapacity() + regData.getRegistryContentHistoryCapacity();
        }
        return UsageUtil.convertBytesToString(totalDataStorage);
    }

    public static String getIncomingBandwidth(BandwidthStatistics bandwidth) {
        long totalBW = 0L;
        if (bandwidth != null) {
            totalBW = bandwidth.getIncomingBandwidth();
        }
        return UsageUtil.convertBytesToString(totalBW);
    }

    public static String getOutgoingBandwidth(BandwidthStatistics bandwidth) {
        long totalBW = 0L;
        if (bandwidth != null) {
            totalBW = bandwidth.getOutgoingBandwidth();
        }
        return UsageUtil.convertBytesToString(totalBW);
    }

    public static String getTotalBandwidth(BandwidthStatistics bandwidth) {
        long totalBW = 0L;
        if (bandwidth != null) {
            totalBW = bandwidth.getIncomingBandwidth() + bandwidth.getOutgoingBandwidth();
        }
        return UsageUtil.convertBytesToString(totalBW);
    }

    public static InstanceUsageStatics[] retrieveInstanceUsage(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            InstanceUsageStatics[] returnInstanceUsage = serviceClient.retrieveInstanceUsage();
            return returnInstanceUsage;
        }
        catch (Exception e) {
            String msg = "Failed to get current instance usage.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static PaginatedInstanceUsage retrievePaginatedInstanceUsages(ServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String requestedPage = request.getParameter("requestedPage");
        int pageNumber = 1;
        boolean numberOfPages = true;
        int entriesPerPage = 15;
        if (requestedPage != null && requestedPage.length() > 0) {
            pageNumber = new Integer(requestedPage);
        }
        try {
            UsageServiceClient serviceClient = new UsageServiceClient(config, session);
            String yearMonth = request.getParameter("year-month");
            if (yearMonth == null) {
                yearMonth = UsageUtil.getCurrentYearMonth();
            }
            return serviceClient.retrievePaginatedInstanceUsage(yearMonth, pageNumber, entriesPerPage);
        }
        catch (Exception e) {
            String msg = "Failed to get paginated instance usages.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }
}

