/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.ui.report;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.usage.stub.beans.xsd.BandwidthStatistics;
import org.wso2.carbon.usage.stub.beans.xsd.RequestStatistics;
import org.wso2.carbon.usage.stub.beans.xsd.TenantUsage;
import org.wso2.carbon.usage.ui.utils.UsageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageReport {
    private TenantUsage usage;
    private String yearMonth;

    public UsageReport(ServletConfig config, HttpSession session, HttpServletRequest request) throws Exception {
        this.usage = UsageUtil.retrieveCurrentTenantUsage((ServletRequest)request, config, session);
        this.yearMonth = (String)request.getSession().getAttribute("year-month");
    }

    public List<String> getUsageReportData() {
        int numberOfUsers = this.usage.getNumberOfUsers();
        if (this.yearMonth == null) {
            this.yearMonth = UsageUtil.getCurrentYearMonth();
        }
        String tenantName = this.usage.getDomain();
        String currentYearMonth = UsageUtil.getCurrentYearMonth();
        ArrayList<String> reportData = new ArrayList<String>();
        reportData.add("Basic Tenant Details");
        reportData.add("");
        reportData.add("Duration");
        reportData.add("Tenant Name");
        reportData.add("Number of users");
        reportData.add("Basic Tenant Details");
        reportData.add("");
        reportData.add(this.yearMonth);
        reportData.add(tenantName);
        reportData.add(String.valueOf(numberOfUsers));
        if (currentYearMonth.equals(this.yearMonth)) {
            reportData.add("Storage Usage");
            reportData.add("Data Storage");
            reportData.add("Current Data Storage");
            reportData.add("Historical Data Storage");
            reportData.add("Total Data Storage");
            String totalDataStorage = UsageUtil.getTotalDataStorage(this.usage);
            String currentDataStorage = UsageUtil.getCurrentDataStorage(this.usage);
            String historyDataStorage = UsageUtil.getHistoryDataStorage(this.usage);
            reportData.add("Storage Usage");
            reportData.add("Registry Content");
            reportData.add(totalDataStorage);
            reportData.add(currentDataStorage);
            reportData.add(historyDataStorage);
        }
        String totRegInBandwidth = UsageUtil.getIncomingBandwidth(this.usage.getTotalRegistryBandwidth());
        String totRegOutBandwidth = UsageUtil.getOutgoingBandwidth(this.usage.getTotalRegistryBandwidth());
        String totRegBandwidth = UsageUtil.getTotalBandwidth(this.usage.getTotalRegistryBandwidth());
        reportData.add("Registry Bandwidth Usage");
        reportData.add("Server Name");
        reportData.add("Incoming Bandwidth");
        reportData.add("Outgoing Bandwidth");
        reportData.add("Total Bandwidth");
        BandwidthStatistics[] regBWStats = this.usage.getRegistryBandwidthStatistics();
        if (regBWStats != null) {
            for (BandwidthStatistics stat : regBWStats) {
                String regInBandwidth = UsageUtil.getIncomingBandwidth(stat);
                String regOutBandwidth = UsageUtil.getOutgoingBandwidth(stat);
                String regBandwidth = UsageUtil.getTotalBandwidth(stat);
                reportData.add("Server Name****");
                reportData.add(regInBandwidth);
                reportData.add(regOutBandwidth);
                reportData.add(regBandwidth);
            }
        }
        reportData.add("Registry Bandwidth Usage");
        reportData.add("All Server Total");
        reportData.add(totRegInBandwidth);
        reportData.add(totRegOutBandwidth);
        reportData.add(totRegBandwidth);
        String totSvcInBandwidth = UsageUtil.getIncomingBandwidth(this.usage.getTotalServiceBandwidth());
        String totSvcOutBandwidth = UsageUtil.getOutgoingBandwidth(this.usage.getTotalServiceBandwidth());
        String totSvcBandwidth = UsageUtil.getTotalBandwidth(this.usage.getTotalServiceBandwidth());
        reportData.add("Service Bandwidth Usage");
        reportData.add("Server Name");
        reportData.add("Incoming Bandwidth");
        reportData.add("Outgoing Bandwidth");
        reportData.add("Total Bandwidth");
        BandwidthStatistics[] svcBWStats = this.usage.getServiceBandwidthStatistics();
        if (svcBWStats != null) {
            for (BandwidthStatistics stat : svcBWStats) {
                String svcInBandwidth = UsageUtil.getIncomingBandwidth(stat);
                String svcOutBandwidth = UsageUtil.getOutgoingBandwidth(stat);
                String svcBandwidth = UsageUtil.getTotalBandwidth(stat);
                reportData.add("Server Name****");
                reportData.add(svcInBandwidth);
                reportData.add(svcOutBandwidth);
                reportData.add(svcBandwidth);
            }
        }
        reportData.add("Service Bandwidth Usage");
        reportData.add("All Server Total");
        reportData.add(totSvcInBandwidth);
        reportData.add(totSvcOutBandwidth);
        reportData.add(totSvcBandwidth);
        String totWebappInBandwidth = UsageUtil.getIncomingBandwidth(this.usage.getTotalWebappBandwidth());
        String totWebappOutBandwidth = UsageUtil.getOutgoingBandwidth(this.usage.getTotalWebappBandwidth());
        String totWebappBandwidth = UsageUtil.getTotalBandwidth(this.usage.getTotalWebappBandwidth());
        BandwidthStatistics[] webappBWStats = this.usage.getWebappBandwidthStatistics();
        reportData.add("Webapp Bandwidth Usage");
        reportData.add("Server Name");
        reportData.add("Incoming Bandwidth");
        reportData.add("Outgoing Bandwidth");
        reportData.add("Total Bandwidth");
        if (webappBWStats != null) {
            for (BandwidthStatistics stat : webappBWStats) {
                String webappInBandwidth = UsageUtil.getIncomingBandwidth(stat);
                String webappOutBandwidth = UsageUtil.getOutgoingBandwidth(stat);
                String webappBandwidth = UsageUtil.getTotalBandwidth(stat);
                reportData.add("Server Name****");
                reportData.add(webappInBandwidth);
                reportData.add(webappOutBandwidth);
                reportData.add(webappBandwidth);
            }
        }
        reportData.add("Webapp Bandwidth Usage");
        reportData.add("All Server Total");
        reportData.add(totWebappInBandwidth);
        reportData.add(totWebappOutBandwidth);
        reportData.add(totWebappBandwidth);
        long totSvcReqCount = this.usage.getTotalRequestStatistics().getRequestCount();
        long totSvcRespCount = this.usage.getTotalRequestStatistics().getResponseCount();
        long totSvcFaultCount = this.usage.getTotalRequestStatistics().getFaultCount();
        RequestStatistics[] svcStats = this.usage.getRequestStatistics();
        reportData.add("Service Usage Statistic");
        reportData.add("Server Name");
        reportData.add("Request Count");
        reportData.add("Response Count");
        reportData.add("Fault Count");
        if (svcStats != null) {
            for (RequestStatistics stat : svcStats) {
                long svcReqCount = stat.getRequestCount();
                long svcResCount = stat.getResponseCount();
                long svcFaultCount = stat.getFaultCount();
                reportData.add("Server Name****");
                reportData.add(String.valueOf(svcReqCount));
                reportData.add(String.valueOf(svcResCount));
                reportData.add(String.valueOf(svcFaultCount));
            }
        }
        reportData.add("Service Usage Statistic");
        reportData.add("All Server Total");
        reportData.add(String.valueOf(totSvcReqCount));
        reportData.add(String.valueOf(totSvcRespCount));
        reportData.add(String.valueOf(totSvcFaultCount));
        return reportData;
    }
}

