/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.ui.report;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.usage.stub.beans.xsd.TenantUsage;
import org.wso2.carbon.usage.ui.report.AllTenantUsageData;
import org.wso2.carbon.usage.ui.utils.UsageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTenantUsageReport {
    private TenantUsage[] tenantUsages;
    private String yearMonth;
    private static final Log log = LogFactory.getLog(AllTenantUsageReport.class);

    public AllTenantUsageReport(ServletConfig config, HttpSession session, HttpServletRequest request) throws Exception {
        this.tenantUsages = UsageUtil.retrieveTenantUsages((ServletRequest)request, config, session);
        this.yearMonth = (String)request.getSession().getAttribute("year-month");
    }

    public List<AllTenantUsageData> getUsageReportData() {
        ArrayList<AllTenantUsageData> reportData = new ArrayList<AllTenantUsageData>();
        if (this.yearMonth == null) {
            this.yearMonth = UsageUtil.getCurrentYearMonth();
        }
        String currentYearMonth = UsageUtil.getCurrentYearMonth();
        try {
            for (TenantUsage usage : this.tenantUsages) {
                AllTenantUsageData usageData = new AllTenantUsageData();
                usageData.setYearMonth(this.yearMonth);
                String currentDataStorage = UsageUtil.getTotalDataStorage(usage);
                String regBandwidth = UsageUtil.getTotalBandwidth(usage.getTotalRegistryBandwidth());
                String svcBandwidth = UsageUtil.getTotalBandwidth(usage.getTotalServiceBandwidth());
                long svcTotalRequest = usage.getTotalRequestStatistics().getRequestCount();
                int numberOfUsers = usage.getNumberOfUsers();
                String tenantName = usage.getDomain();
                int tenantId = usage.getTenantId();
                String fullReportLink = "any_tenant_usage.jsp?tenant-id=" + tenantId + "&year-month=" + this.yearMonth;
                usageData.setTenantName(tenantName);
                if (this.yearMonth.equals(currentYearMonth)) {
                    usageData.setNumberOfUsers(Integer.toString(numberOfUsers));
                    usageData.setCurrentDataStorage(currentDataStorage);
                } else {
                    usageData.setNumberOfUsers("-");
                    usageData.setCurrentDataStorage("-");
                }
                usageData.setRegBandwidth(regBandwidth);
                usageData.setSvcBandwidth(svcBandwidth);
                usageData.setSvcTotalRequest(Long.toString(svcTotalRequest));
                reportData.add(usageData);
            }
        }
        catch (Exception e) {
            String msg = "Error while retrieving tenant usages for month : " + this.yearMonth;
            log.error((Object)msg, (Throwable)e);
        }
        return reportData;
    }
}

