/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.usage.stub.beans.xsd.InstanceUsageStatics;
import org.wso2.carbon.usage.stub.beans.xsd.PaginatedInstanceUsage;
import org.wso2.carbon.usage.stub.beans.xsd.PaginatedTenantUsageInfo;
import org.wso2.carbon.usage.stub.beans.xsd.TenantUsage;
import org.wso2.carbon.usage.stub.services.UsageServiceStub;

public class UsageServiceClient {
    private static final Log log = LogFactory.getLog(UsageServiceClient.class);
    private UsageServiceStub stub;
    private String epr;

    public UsageServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "UsageService";
        try {
            this.stub = new UsageServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate UsageService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public UsageServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "UsageService";
        try {
            this.stub = new UsageServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate UsageService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public TenantUsage retrieveCurrentTenantUsage(String yearMonth) throws Exception {
        return this.stub.retrieveCurrentTenantUsage(yearMonth);
    }

    public TenantUsage[] retrieveTenantUsages(String yearMonth) throws Exception {
        return this.stub.retrieveTenantUsages(yearMonth);
    }

    public PaginatedTenantUsageInfo retrievePaginatedTenantUsages(String yearMonth, int pageNumber, int entriesPerPage) throws Exception {
        return this.stub.retrievePaginatedTenantUsages(yearMonth, pageNumber, entriesPerPage);
    }

    public TenantUsage retrieveTenantUsage(String yearMonth, int tenantId) throws Exception {
        return this.stub.retrieveTenantUsage(yearMonth, tenantId);
    }

    public InstanceUsageStatics[] retrieveInstanceUsage() throws Exception {
        return this.stub.retrieveInstanceUsage();
    }

    public PaginatedInstanceUsage retrievePaginatedInstanceUsage(String yearMonth, int pageNumber, int numbersPerPage) throws Exception {
        return this.stub.retrievePaginatedInstanceUsage(yearMonth, pageNumber, numbersPerPage);
    }
}

