/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.persist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.config.UsageAgentConfiguration;
import org.wso2.carbon.usage.agent.exception.UsageException;
import org.wso2.carbon.usage.agent.util.PublisherUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageDataPersistenceTask
implements Runnable {
    private static final Log log = LogFactory.getLog(UsageDataPersistenceTask.class);
    private Queue<BandwidthUsage> usagePersistenceJobs;
    private UsageAgentConfiguration configuration;

    public UsageDataPersistenceTask(Queue<BandwidthUsage> jobs, UsageAgentConfiguration configuration) {
        this.usagePersistenceJobs = jobs;
        this.configuration = configuration;
    }

    @Override
    public void run() {
        if (!this.usagePersistenceJobs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisting Service and Web App bandwidth usage statistics");
            }
            try {
                this.persistUsage(this.usagePersistenceJobs);
            }
            catch (UsageException e) {
                log.error((Object)"Error when persisting usage statistics.", (Throwable)e);
            }
        }
    }

    public void persistUsage(Queue<BandwidthUsage> jobQueue) throws UsageException {
        HashMap<Integer, Summarizer> summarizerMap = new HashMap<Integer, Summarizer>();
        for (int i = 0; i < this.configuration.getUsageTasksNumberOfRecordsPerExecution() && !jobQueue.isEmpty(); ++i) {
            BandwidthUsage usage = jobQueue.poll();
            int tenantId = usage.getTenantId();
            Summarizer summarizer = (Summarizer)summarizerMap.get(tenantId);
            if (summarizer == null) {
                summarizer = new Summarizer();
                summarizerMap.put(tenantId, summarizer);
            }
            summarizer.accumulate(usage);
        }
        Collection summarizers = summarizerMap.values();
        for (Summarizer summarizer : summarizers) {
            summarizer.publish();
        }
    }

    private static class Summarizer {
        private HashMap<String, BandwidthUsage> usageMap = new HashMap();

        public void accumulate(BandwidthUsage usage) {
            String key = usage.getMeasurement();
            BandwidthUsage existingUsage = this.usageMap.get(key);
            if (existingUsage != null) {
                existingUsage.setValue(existingUsage.getValue() + usage.getValue());
            } else {
                this.usageMap.put(key, usage);
            }
        }

        public void publish() throws UsageException {
            Collection<BandwidthUsage> usages = this.usageMap.values();
            for (BandwidthUsage usage : usages) {
                try {
                    if (-1234 == usage.getTenantId()) continue;
                    PublisherUtils.publish(usage);
                }
                catch (UsageException e) {
                    log.error((Object)"Error in publishing bandwidth usage data", (Throwable)e);
                }
            }
        }
    }
}

