/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.util;

import java.net.SocketException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.exception.UsageException;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class PublisherUtils {
    private static Log log = LogFactory.getLog(PublisherUtils.class);
    private static final String TRANSPORT = "https";
    private static ConfigurationContextService configurationContextService;

    public static String updateServerName(int tenantId) throws UsageException {
        String hostName;
        try {
            hostName = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new UsageException("Error getting host name for the registry usage event payload", e);
        }
        ConfigurationContextService configurationContextService = PublisherUtils.getConfigurationContextService();
        if (configurationContextService == null) {
            throw new UsageException("ConfigurationContext is null");
        }
        ConfigurationContext configurationContext = configurationContextService.getServerConfigContext();
        String carbonHttpsPort = System.getProperty("carbon.https.port");
        if (carbonHttpsPort == null) {
            carbonHttpsPort = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)configurationContext, (String)TRANSPORT));
        }
        String baseServerUrl = "https://" + hostName + ":" + carbonHttpsPort;
        String context = configurationContext.getContextRoot();
        String tenantDomain = null;
        try {
            Tenant tenant = Util.getRealmService().getTenantManager().getTenant(tenantId);
            if (tenant != null) {
                tenantDomain = tenant.getDomain();
            }
        }
        catch (UserStoreException e) {
            throw new UsageException("Failed to get tenant domain", (Exception)((Object)e));
        }
        String serverName = tenantDomain != null && !tenantDomain.equals("carbon.super") ? baseServerUrl + context + "t/" + tenantDomain : (context.equals("/") ? baseServerUrl + "" : baseServerUrl + context);
        return serverName;
    }

    public static OMElement getEventPayload(BandwidthUsage usage) throws Exception {
        String measurement = usage.getMeasurement();
        String value = Long.toString(usage.getValue());
        int tenantId = usage.getTenantId();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace statNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/server/user-defined/data", "svrusrdata");
        OMElement eventElement = factory.createOMElement("Event", statNamespace);
        OMElement serviceInvocationDataElement = factory.createOMElement("ServerUserDefinedData", statNamespace);
        eventElement.addChild((OMNode)serviceInvocationDataElement);
        OMElement serverNameElement = factory.createOMElement("ServerName", statNamespace);
        String serverName = PublisherUtils.updateServerName(usage.getTenantId());
        factory.createOMText((OMContainer)serverNameElement, serverName);
        serviceInvocationDataElement.addChild((OMNode)serverNameElement);
        OMElement tenantElement = factory.createOMElement("TenantID", statNamespace);
        factory.createOMText((OMContainer)tenantElement, Integer.toString(tenantId));
        serviceInvocationDataElement.addChild((OMNode)tenantElement);
        OMElement dataElement = factory.createOMElement("Data", statNamespace);
        serviceInvocationDataElement.addChild((OMNode)dataElement);
        OMElement keyElement = factory.createOMElement("Key", statNamespace);
        factory.createOMText((OMContainer)keyElement, measurement);
        dataElement.addChild((OMNode)keyElement);
        OMElement valueElement = factory.createOMElement("Value", statNamespace);
        factory.createOMText((OMContainer)valueElement, value);
        dataElement.addChild((OMNode)valueElement);
        return eventElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(BandwidthUsage usage) throws UsageException {
        Message message;
        try {
            OMElement statMessage = PublisherUtils.getEventPayload(usage);
            message = new Message();
            message.setMessage(statMessage);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get usage event payload", (Throwable)e);
            return;
        }
        String topic = "carbon/bam/data/publishers/bandwidth-stat";
        EventBroker eventBrokerService = Util.getEventBrokerService();
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
            eventBrokerService.publishRobust(message, topic);
        }
        catch (EventBrokerException e) {
            log.error((Object)"SystemStatisticsHandler - Unable to send notification for stat threshold", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        PublisherUtils.configurationContextService = configurationContextService;
    }
}

