/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.persist;

import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.ext.transport.statistics.TransportStatisticsContainer;
import org.wso2.carbon.tomcat.ext.transport.statistics.TransportStatisticsEntry;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.config.UsageAgentConfiguration;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.UserStoreException;

public class BandwidthUsageDataRetrievalTask
implements Runnable {
    private static final Log log = LogFactory.getLog(BandwidthUsageDataRetrievalTask.class);
    private Queue<TransportStatisticsEntry> transportStats = TransportStatisticsContainer.getTransportStatistics();
    private UsageAgentConfiguration configuration;

    public BandwidthUsageDataRetrievalTask(UsageAgentConfiguration configuration) {
        this.configuration = configuration;
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving Service and Web App bandwidth usage statistics.");
        }
        if (!this.transportStats.isEmpty()) {
            for (int i = 0; i < this.configuration.getUsageTasksNumberOfRecordsPerExecution() && !this.transportStats.isEmpty(); ++i) {
                TransportStatisticsEntry entry = this.transportStats.remove();
                try {
                    int tenantId = this.getTenantID(entry.getTenantName());
                    if (tenantId < 0) {
                        return;
                    }
                    if (this.inferMeasurement(entry).equals("ServiceBandwidth")) {
                        if (entry.getRequestSize() > 0L) {
                            Util.addToPersistingControllerQueue(new BandwidthUsage(this.getTenantID(entry.getTenantName()), "ServiceBandwidth-In", entry.getRequestSize()));
                        }
                        if (entry.getResponseSize() <= 0L) continue;
                        Util.addToPersistingControllerQueue(new BandwidthUsage(this.getTenantID(entry.getTenantName()), "ServiceBandwidth-Out", entry.getResponseSize()));
                        continue;
                    }
                    if (!this.inferMeasurement(entry).equals("WebappBandwidth")) continue;
                    if (entry.getRequestSize() > 0L) {
                        Util.addToPersistingControllerQueue(new BandwidthUsage(this.getTenantID(entry.getTenantName()), "WebappBandwidth-In", entry.getRequestSize()));
                    }
                    if (entry.getResponseSize() <= 0L) continue;
                    Util.addToPersistingControllerQueue(new BandwidthUsage(this.getTenantID(entry.getTenantName()), "WebappBandwidth-Out", entry.getResponseSize()));
                    continue;
                }
                catch (UserStoreException e) {
                    log.error((Object)"Error persisting bandwidth usage statistics.", (Throwable)e);
                }
            }
        }
    }

    private String inferMeasurement(TransportStatisticsEntry entry) {
        if (entry.getContext() != null) {
            if (entry.getContext().equals("services")) {
                return "ServiceBandwidth";
            }
            if (entry.getContext().equals("webapps")) {
                return "WebappBandwidth";
            }
        }
        return "carbon";
    }

    private int getTenantID(String tenantDomain) throws UserStoreException {
        return Util.getRealmService().getTenantManager().getTenantId(tenantDomain);
    }
}

