/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.utils;

import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskScheduler;
import org.apache.synapse.task.TaskSchedulerFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.mgt.api.MultitenancyBillingInfo;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyPackage;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.throttling.agent.client.ThrottlingRuleInvoker;
import org.wso2.carbon.throttling.manager.conf.ThrottlingConfiguration;
import org.wso2.carbon.throttling.manager.dataproviders.DataProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.scheduling.ThrottlingJob;
import org.wso2.carbon.throttling.manager.services.MultitenancyThrottlingService;
import org.wso2.carbon.throttling.manager.tasks.Task;
import org.wso2.carbon.usage.api.TenantUsageRetriever;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static RuleEngineConfigService ruleEngineConfigService;
    private static BillingManager billingManager;
    private static BundleContext bundleContext;
    private static TenantUsageRetriever tenantUsageRetriever;
    private static MultitenancyBillingInfo mtBillingInfo;
    private static final String THROTTLING_CONFIG = "usage-throttling-agent-config.xml";
    private static final String THROTTLING_TASK_ID = "throttling-task";
    private static ThrottlingConfiguration throttlingConfiguration;
    private static final String THROTTLING_RULE_FILE = "throttling-rules.drl";

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static synchronized void setBundleContext(BundleContext context) {
        if (bundleContext == null) {
            bundleContext = context;
        }
    }

    public static void setTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        Util.tenantUsageRetriever = tenantUsageRetriever;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static UserRegistry getSuperTenantGovernanceSystemRegistry() throws RegistryException {
        return registryService.getGovernanceSystemRegistry();
    }

    public static TenantUsageRetriever getTenantUsageRetriever() {
        return tenantUsageRetriever;
    }

    public static void setRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
        Util.ruleEngineConfigService = ruleEngineConfigService;
    }

    public static RuleEngineConfigService getRuleEngineConfigService() {
        return ruleEngineConfigService;
    }

    public static BillingManager getBillingManager() {
        return billingManager;
    }

    public static void setBillingManager(BillingManager billingManager) {
        Util.billingManager = billingManager;
    }

    public static Customer getCurrentBillingCustomer(int tenantId) throws RegistryException {
        Customer customer;
        Tenant tenant;
        if (tenantId == -1234) {
            return null;
        }
        try {
            tenant = (Tenant)realmService.getTenantManager().getTenant(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Error in getting the realm Information.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (tenant == null) {
            return null;
        }
        String customerName = tenant.getDomain();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        try {
            if (billingEngine != null) {
                List customers = billingEngine.getCustomersWithName(customerName);
                customer = customers == null || customers.size() == 0 ? null : (Customer)customers.get(0);
            } else {
                customer = null;
                String msg = "Error in getting billing Engine";
                log.error((Object)msg);
            }
        }
        catch (BillingException e) {
            String msg = "Error in getting the current customer";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return customer;
    }

    public static Subscription getCurrentSubscription(int tenantId) throws RegistryException {
        Item item;
        List subscriptions;
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyScheduledTask");
        Customer customer = Util.getCurrentBillingCustomer(tenantId);
        if (customer == null) {
            return null;
        }
        try {
            subscriptions = billingEngine.getActiveSubscriptions(customer);
        }
        catch (BillingException e) {
            String msg = "Error in getting the current subscription.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (subscriptions == null || subscriptions.size() == 0) {
            return null;
        }
        Subscription subscription = (Subscription)subscriptions.get(0);
        if (subscription.getActiveUntil().getTime() <= System.currentTimeMillis()) {
            return null;
        }
        int itemId = subscription.getItem().getId();
        try {
            item = billingEngine.getItem(itemId);
        }
        catch (BillingException e) {
            String msg = "Error in getting the item for item id: " + itemId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        subscription.setItem(item);
        return subscription;
    }

    public static MultitenancyPackage getCurrentBillingPackage(int tenantId) throws RegistryException {
        if (mtBillingInfo == null) {
            String msg = "Error in retrieving the current billing package. The package info is null.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        List multitenancyPackages = mtBillingInfo.getMultitenancyPackages();
        Subscription subscription = Util.getCurrentSubscription(tenantId);
        Item currentPackage = subscription == null ? null : subscription.getItem();
        MultitenancyPackage currentMultitenancyPackage = null;
        for (MultitenancyPackage multitenancyPackage : multitenancyPackages) {
            if (multitenancyPackage.getName().toLowerCase().contains("free") && currentPackage == null) {
                currentMultitenancyPackage = multitenancyPackage;
                break;
            }
            if (currentPackage == null || !multitenancyPackage.getName().equals(currentPackage.getName())) continue;
            currentMultitenancyPackage = multitenancyPackage;
            break;
        }
        return currentMultitenancyPackage;
    }

    public static int getMaximumUsersAllow(int tenantId) throws RegistryException {
        MultitenancyPackage multitenancyPackage = Util.getCurrentBillingPackage(tenantId);
        if (multitenancyPackage == null) {
            String msg = "The multitenancy package is null.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return multitenancyPackage.getUsersLimit();
    }

    public static long getMaximumResourceVolume(int tenantId) throws RegistryException {
        MultitenancyPackage multitenancyPackage = Util.getCurrentBillingPackage(tenantId);
        if (multitenancyPackage == null) {
            String msg = "The multitenancy package is null.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return (long)multitenancyPackage.getResourceVolumeLimit() * 1024L * 1024L;
    }

    public static String getCurrentMonthString(Calendar calendar) {
        int currentMonth = calendar.get(2);
        String[] monthArr = new DateFormatSymbols().getMonths();
        String month = monthArr[currentMonth];
        return calendar.get(1) + "-" + month;
    }

    public static void registerTaskOSGIService(Task task) {
        if (bundleContext != null) {
            bundleContext.registerService(Task.class.getName(), (Object)task, null);
        }
    }

    public static void registerHandlerOSGIService(DataProvider handler) {
        if (bundleContext != null) {
            bundleContext.registerService(DataProvider.class.getName(), (Object)handler, null);
        }
    }

    public static void setMultitenancyBillingInfo(MultitenancyBillingInfo mtBillingInfo) {
        Util.mtBillingInfo = mtBillingInfo;
    }

    public static Object constructObject(String className) throws ThrottlingException {
        Object obj;
        Constructor<?> co;
        Class<?> cl;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String msg = "The class: " + className + " is not in the classpath.";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
        try {
            co = cl.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "The default constructor for the  is not available for " + className + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
        try {
            obj = co.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String msg = "Error in initializing the object for " + className + ".";
            log.error((Object)msg);
            throw new ThrottlingException(msg, e);
        }
        return obj;
    }

    public static void registerThrottlingRuleInvoker() {
        bundleContext.registerService(ThrottlingRuleInvoker.class.getName(), (Object)new MultitenancyThrottlingService(), null);
    }

    public static void initializeThrottling() throws ThrottlingException {
        String configFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + THROTTLING_CONFIG;
        throttlingConfiguration = new ThrottlingConfiguration(configFile);
        List<Task> throttlingTasks = throttlingConfiguration.getThrottlingTasks();
        for (Task throttlingTask : throttlingTasks) {
            Util.initializeScheduling(throttlingTask);
        }
    }

    private static void initializeScheduling(Task throttlingTask) {
        if (throttlingTask.getTriggerInterval() < 0) {
            log.info((Object)"Throttling manager Validation info service Disabled");
        } else {
            String taskName = UUIDGenerator.generateUUID();
            String groupId = UUIDGenerator.generateUUID();
            TaskDescription taskDescription = new TaskDescription();
            taskDescription.setName(taskName);
            taskDescription.setGroup(groupId);
            taskDescription.setInterval((long)throttlingTask.getTriggerInterval());
            Calendar startTime = Calendar.getInstance();
            startTime.add(14, throttlingTask.getStartDelayInterval());
            taskDescription.setStartTime(startTime.getTime());
            HashMap<String, Task> resources = new HashMap<String, Task>();
            resources.put("throttlingTask", throttlingTask);
            TaskScheduler taskScheduler = TaskSchedulerFactory.getTaskScheduler((String)THROTTLING_TASK_ID);
            if (!taskScheduler.isInitialized()) {
                Properties properties = new Properties();
                taskScheduler.init(properties);
            }
            taskScheduler.scheduleTask(taskDescription, resources, ThrottlingJob.class);
        }
    }

    public static Tenant[] getAllTenants() throws UserStoreException {
        TenantManager tenantManager = realmService.getTenantManager();
        try {
            return (Tenant[])tenantManager.getAllTenants();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException((Throwable)e);
        }
    }

    public static List<Task> getTasks() {
        return throttlingConfiguration.getThrottlingTasks();
    }

    public static void loadThrottlingRules() throws Exception {
        UserRegistry systemRegistry = Util.getSuperTenantGovernanceSystemRegistry();
        if (systemRegistry.resourceExists("/repository/components/org.wso2.carbon.throttling-rules")) {
            return;
        }
        String throttlingRuleFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + THROTTLING_RULE_FILE;
        byte[] content = CarbonUtils.getBytesFromFile((File)new File(throttlingRuleFile));
        Resource ruleResource = systemRegistry.newResource();
        ruleResource.setContent((Object)content);
        systemRegistry.put("/repository/components/org.wso2.carbon.throttling-rules", ruleResource);
    }
}

