/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.utils;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.conf.ThrottlingTaskDataProviderConfiguration;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProviderIterator
implements Iterator {
    private static final Log log = LogFactory.getLog(DataProviderIterator.class);
    private ThreadLocal<Integer> index = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    List<ThrottlingTaskDataProviderConfiguration> dataProviderConfigs;

    public DataProviderIterator(List<ThrottlingTaskDataProviderConfiguration> dataProviderConfigs) {
        this.dataProviderConfigs = dataProviderConfigs;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        int i = this.index.get();
        return i < this.dataProviderConfigs.size();
    }

    public Object next() {
        int i = this.index.get();
        ThrottlingTaskDataProviderConfiguration handlerConfig = this.dataProviderConfigs.get(i++);
        this.index.set(i);
        try {
            return handlerConfig.getDataProvider();
        }
        catch (ThrottlingException e) {
            String msg = "DataProvider for the dataProviderConfigs config is null. dataProviderConfigs index: " + (i - 1) + ".";
            log.error((Object)msg);
            return null;
        }
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.index.set(0);
    }
}

