/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.rules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntimeFactory;
import org.wso2.carbon.rule.kernel.backend.Session;
import org.wso2.carbon.rule.kernel.config.RuleEngineProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.utils.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleInvoker {
    private static final Log log = LogFactory.getLog(RuleInvoker.class);
    Session session;

    public RuleInvoker() throws ThrottlingException {
        this.updateRules();
    }

    public synchronized void invoke(List<Object> knowledgeBase) throws ThrottlingException {
        try {
            this.session.execute(knowledgeBase);
        }
        catch (Exception e) {
            String msg = "Error occurred while executing the throttling rules: " + e.getMessage();
            log.error((Object)msg);
            throw new ThrottlingException(msg, e);
        }
    }

    public synchronized void updateRules() throws ThrottlingException {
        RuleEngineProvider ruleEngineProvider = Util.getRuleEngineConfigService().getRuleConfig().getRuleEngineProvider();
        try {
            Class<?> ruleBackendRuntimeFactoryClass = Class.forName(ruleEngineProvider.getClassName());
            RuleBackendRuntimeFactory ruleBackendRuntimeFactory = (RuleBackendRuntimeFactory)ruleBackendRuntimeFactoryClass.newInstance();
            RuleBackendRuntime ruleBackendRuntime = ruleBackendRuntimeFactory.getRuleBackendRuntime(ruleEngineProvider.getProperties(), Thread.currentThread().getContextClassLoader());
            RuleSet ruleSet = new RuleSet();
            Rule rule = new Rule();
            rule.setResourceType("regular");
            rule.setSourceType("registry");
            rule.setValue("gov:/repository/components/org.wso2.carbon.throttling-rules");
            ruleSet.addRule(rule);
            ruleBackendRuntime.addRuleSet(ruleSet);
            this.session = ruleBackendRuntime.createSession(2);
        }
        catch (Exception e) {
            String msg = "Error occurred while initializing the rule executing environment: " + e.getMessage();
            log.error((Object)msg);
            throw new ThrottlingException(msg, e);
        }
    }
}

