/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.rules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataEntry;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.tasks.Task;
import org.wso2.carbon.throttling.manager.validation.ValidationInfoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBaseManager {
    private static final Log log = LogFactory.getLog(KnowledgeBaseManager.class);

    public static ThrottlingDataContext feedKnowledgeBase(int tenantId, Task task, List<Object> knowledgeBase) throws ThrottlingException {
        ThrottlingDataContext throttlingDataContext = new ThrottlingDataContext(tenantId);
        try {
            task.prepareData(throttlingDataContext);
        }
        catch (ThrottlingException e) {
            String msg = "Error in preparing throttling data for tenant: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
        for (ThrottlingDataEntry dataEntry : throttlingDataContext.getData()) {
            Object object;
            if (dataEntry.getValueType() != 4 || (object = dataEntry.getObjectValue()) == null) continue;
            knowledgeBase.add(object);
        }
        try {
            ValidationInfoManager.loadValidationDetails(throttlingDataContext);
        }
        catch (ThrottlingException e) {
            String msg = "Error in loading validation details. tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, e);
        }
        knowledgeBase.add(throttlingDataContext);
        knowledgeBase.add(throttlingDataContext.getAccessValidation());
        return throttlingDataContext;
    }
}

