/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.manager.dataproviders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyPackage;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.throttling.manager.dataobjects.ThrottlingDataContext;
import org.wso2.carbon.throttling.manager.dataproviders.DataProvider;
import org.wso2.carbon.throttling.manager.exception.ThrottlingException;
import org.wso2.carbon.throttling.manager.utils.Util;

public class BillingDataProvider
extends DataProvider {
    private static Log log = LogFactory.getLog(BillingDataProvider.class);

    public void invoke(ThrottlingDataContext dataContext) throws ThrottlingException {
        int tenantId = dataContext.getTenantId();
        try {
            Customer customer = Util.getCurrentBillingCustomer(tenantId);
            dataContext.addDataObject("customer", customer);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the current customer. tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, (Exception)((Object)e));
        }
        try {
            MultitenancyPackage mtPackage = Util.getCurrentBillingPackage(tenantId);
            dataContext.addDataObject("package", mtPackage);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the multi-tenancy package. tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlingException(msg, (Exception)((Object)e));
        }
    }
}

