/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingInfoCache {
    private static final Log log = LogFactory.getLog(ThrottlingInfoCache.class);
    private Map<Integer, TenantThrottlingInfo> tenantThrottlingInfoMap = new ConcurrentHashMap<Integer, TenantThrottlingInfo>();

    public void addTenant(int tenantId) {
        this.tenantThrottlingInfoMap.put(tenantId, new TenantThrottlingInfo());
    }

    public void deleteTenant(int tenantId) {
        this.tenantThrottlingInfoMap.remove(tenantId);
    }

    public Set<Integer> getActiveTenants() {
        return this.tenantThrottlingInfoMap.keySet();
    }

    public void updateThrottlingActionInfo(int tenantId, String action, ThrottlingActionInfo throttlingActionInfo) {
        TenantThrottlingInfo throttlingInfo = this.tenantThrottlingInfoMap.get(tenantId);
        throttlingInfo.updateThrottlingActionInfo(action, throttlingActionInfo);
    }

    public ThrottlingActionInfo getThrottlingActionInfo(int tenantId, String action) {
        if (this.tenantThrottlingInfoMap.get(tenantId) != null) {
            return this.tenantThrottlingInfoMap.get(tenantId).getThrottlingActionInfo(action);
        }
        return null;
    }

    public TenantThrottlingInfo getTenantThrottlingInfo(int tenantId) {
        if (!this.tenantThrottlingInfoMap.containsKey(tenantId)) {
            this.tenantThrottlingInfoMap.put(tenantId, new TenantThrottlingInfo());
        }
        return this.tenantThrottlingInfoMap.get(tenantId);
    }
}

