/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.throttling.stub.services.ThrottlingRuleEditorServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ThrottlingRuleEditorClient {
    private static final Log log = LogFactory.getLog(ThrottlingRuleEditorClient.class);
    private ThrottlingRuleEditorServiceStub stub;
    private String epr;

    public ThrottlingRuleEditorClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ThrottlingRuleEditorService";
        try {
            this.stub = new ThrottlingRuleEditorServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate throttling rule editor service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ThrottlingRuleEditorClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ThrottlingRuleEditorService";
        try {
            this.stub = new ThrottlingRuleEditorServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate throttling rule editor service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String retrieveThrottlingRules() throws Exception {
        return this.stub.retrieveThrottlingRules();
    }

    public void updateThrottlingRules(String ruleContent) throws Exception {
        this.stub.updateThrottlingRules(ruleContent);
    }
}

