/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.SSOAssertionConsumerService;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.authenticator.SAML2SSOUIAuthenticator;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.filters.LoginPageFilter;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SAML2SSOAuthenticatorUIDSComponent {
    private static final Log log = LogFactory.getLog(SAML2SSOAuthenticatorUIDSComponent.class);

    protected void activate(ComponentContext ctxt) {
        if (Util.isAuthenticatorEnabled()) {
            boolean initSuccess = Util.initSSOConfigParams();
            if (initSuccess) {
                HttpServlet loginServlet = new HttpServlet(){

                    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                    }
                };
                LoginPageFilter loginPageFilter = new LoginPageFilter();
                Hashtable loginPageFilterProps = new Hashtable(2);
                Hashtable<String, Object> redirectorParams = new Hashtable<String, Object>(3);
                ((Dictionary)redirectorParams).put("url-pattern", Util.getLoginPage());
                ((Dictionary)redirectorParams).put("associated-filter", loginPageFilter);
                ((Dictionary)redirectorParams).put("servlet-attributes", loginPageFilterProps);
                ctxt.getBundleContext().registerService(Servlet.class.getName(), (Object)loginServlet, redirectorParams);
                SSOAssertionConsumerService acsServlet = new SSOAssertionConsumerService();
                Hashtable<String, String> acsParams = new Hashtable<String, String>(2);
                ((Dictionary)acsParams).put("url-pattern", "/acs");
                ((Dictionary)acsParams).put("display-name", "SAML SSO Assertion Consumer Service");
                ctxt.getBundleContext().registerService(Servlet.class.getName(), (Object)acsServlet, acsParams);
                SAML2SSOUIAuthenticator authenticator = new SAML2SSOUIAuthenticator();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("authenticator.type", authenticator.getAuthenticatorName());
                ctxt.getBundleContext().registerService(CarbonUIAuthenticator.class.getName(), (Object)authenticator, props);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SAML2 SSO Authenticator BE Bundle activated successfully.");
                }
            } else {
                log.warn((Object)"Initialization failed for SSO Authenticator. Starting with the default authenticator");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"SAML2 SSO Authenticator is disabled");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"SAML2 SSO Authenticator FE Bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        SAML2SSOAuthFEDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        SAML2SSOAuthFEDataHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        SAML2SSOAuthFEDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        SAML2SSOAuthFEDataHolder.getInstance().setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtxtService) {
        SAML2SSOAuthFEDataHolder.getInstance().setConfigurationContextService(configCtxtService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxtService) {
        SAML2SSOAuthFEDataHolder.getInstance().setConfigurationContextService(null);
    }

    protected void setCarbonSSOSessionManagerInstance(CarbonSSOSessionManager carbonSSOSessionMgr) {
        SAML2SSOAuthFEDataHolder.getInstance().setCarbonSSOSessionManager(carbonSSOSessionMgr);
    }

    protected void unsetCarbonSSOSessionManagerInstance(CarbonSSOSessionManager carbonSSOSessionMgr) {
        SAML2SSOAuthFEDataHolder.getInstance().setCarbonSSOSessionManager(null);
    }
}

