/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.authenticator;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Response;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.client.SAML2SSOAuthenticationClient;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.ui.AbstractCarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SAML2SSOUIAuthenticator
extends AbstractCarbonUIAuthenticator {
    private static final int DEFAULT_PRIORITY_LEVEL = 50;
    public static final Log log = LogFactory.getLog(SAML2SSOUIAuthenticator.class);

    public boolean isHandle(Object o) {
        HttpServletRequest request = (HttpServletRequest)o;
        String relayState = request.getParameter("RelayState");
        Object samlResponse = request.getAttribute("SAML2ResponseToken");
        if (request.getRequestURI().indexOf("/carbon/admin/logout_action.jsp") > -1) {
            return true;
        }
        return samlResponse != null && samlResponse instanceof Response && relayState != null;
    }

    public boolean authenticate(Object o) throws AuthenticationException {
        boolean isAuthenticated = false;
        HttpServletRequest request = (HttpServletRequest)o;
        HttpSession session = request.getSession();
        Response samlResponse = (Response)request.getAttribute("SAML2ResponseToken");
        String responseStr = request.getParameter("SAMLResponse");
        String username = this.getUsernameFromResponse(samlResponse);
        ServletContext servletContext = request.getSession().getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String backEndServerURL = request.getParameter("backendURL");
        if (backEndServerURL == null) {
            backEndServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)session);
        }
        session.setAttribute("ServerURL", (Object)backEndServerURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        SAML2SSOAuthenticationClient authenticationClient = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking the SAML2 SSO Authenticator BE for the Response : " + responseStr));
            }
            if (isAuthenticated = (authenticationClient = new SAML2SSOAuthenticationClient(configContext, backEndServerURL, cookie, session)).login(responseStr, username)) {
                CarbonSSOSessionManager ssoSessionManager = SAML2SSOAuthFEDataHolder.getInstance().getCarbonSSOSessionManager();
                ssoSessionManager.addSessionMapping(this.getSessionIndexFromResponse(samlResponse), session.getId());
            } else {
                log.error((Object)"Authentication failed.");
            }
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)("Error when authenticating the user : " + username), (Throwable)e);
            throw new AuthenticationException("Error when authenticating the user : " + username, (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error when creating SAML2SSOAuthenticationClient.", (Throwable)e);
            throw new AuthenticationException("Error when creating SAML2SSOAuthenticationClient.", (Throwable)e);
        }
        return isAuthenticated;
    }

    public void unauthenticate(Object o) throws Exception {
        HttpServletRequest request = (HttpServletRequest)o;
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)session);
        try {
            String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            SAML2SSOAuthenticationClient authClient = new SAML2SSOAuthenticationClient(configContext, backendServerURL, cookie, session);
            authClient.logout(session);
        }
        catch (Exception ignored) {
            String msg = "Configuration context is null.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        request.setAttribute("logoutRequest", (Object)true);
        request.setAttribute("loggedInUser", session.getAttribute("logged-user"));
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 50;
    }

    public String getAuthenticatorName() {
        return "SAML2SSOAuthenticator";
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    private String getUsernameFromResponse(Response response) {
        List assertions = response.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
            return assertion.getSubject().getNameID().getValue();
        }
        return null;
    }

    private String getSessionIndexFromResponse(Response response) {
        List authnStatements;
        List assertions = response.getAssertions();
        String sessionIndex = null;
        if (assertions != null && assertions.size() > 0 && (authnStatements = ((Assertion)assertions.get(0)).getAuthnStatements()) != null && authnStatements.size() > 0) {
            AuthnStatement authStmt = (AuthnStatement)authnStatements.get(0);
            sessionIndex = authStmt.getSessionIndex();
        }
        return sessionIndex;
    }

    public boolean reAuthenticateOnSessionExpire(Object object) throws AuthenticationException {
        return false;
    }
}

