/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAbstractTypeSchemaValidator<RequestType extends RequestAbstractType>
implements Validator<RequestType> {
    @Override
    public void validate(RequestType requestAbstractType) throws ValidationException {
        this.validateVersion((RequestAbstractType)requestAbstractType);
        this.validateID((RequestAbstractType)requestAbstractType);
        this.validateIssueInstant((RequestAbstractType)requestAbstractType);
    }

    protected void validateVersion(RequestAbstractType request) throws ValidationException {
        if (request.getMajorVersion() != 1 && (request.getMinorVersion() != 0 || request.getMinorVersion() != 1)) {
            throw new ValidationException("Invalid Version");
        }
    }

    protected void validateID(RequestAbstractType request) throws ValidationException {
        if (DatatypeHelper.isEmpty(request.getID())) {
            throw new ValidationException("RequestID is null, empty or whitespace");
        }
    }

    protected void validateIssueInstant(RequestAbstractType request) throws ValidationException {
        if (request.getIssueInstant() == null) {
            throw new ValidationException("No IssueInstant attribute present");
        }
    }
}

