/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.validator.SubjectStatementSchemaValidator;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationDecisionStatementSchemaValidator
extends SubjectStatementSchemaValidator<AuthorizationDecisionStatement> {
    @Override
    public void validate(AuthorizationDecisionStatement authorizationDecisionStatement) throws ValidationException {
        super.validate(authorizationDecisionStatement);
        this.validateResource(authorizationDecisionStatement);
        this.validateDecision(authorizationDecisionStatement);
        this.validateActions(authorizationDecisionStatement);
    }

    protected void validateResource(AuthorizationDecisionStatement statement) throws ValidationException {
        if (DatatypeHelper.isEmpty(statement.getResource())) {
            throw new ValidationException("Resource attribute not present or invalid");
        }
    }

    protected void validateDecision(AuthorizationDecisionStatement statement) throws ValidationException {
        if (statement.getDecision() == null) {
            throw new ValidationException("No Decision element present");
        }
    }

    protected void validateActions(AuthorizationDecisionStatement statement) throws ValidationException {
        if (statement.getActions().size() == 0) {
            throw new ValidationException("No Action elements present");
        }
    }
}

