/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.activation.utils;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class ActivationManager {
    private static final ConcurrentHashMap<Integer, Boolean> activations = new ConcurrentHashMap();
    private static Timer timer = null;

    public static void startCacheCleaner() {
        CacheCleaner faultyServiceRectifier = new CacheCleaner();
        timer = new Timer();
        long retryIn = 60000L;
        timer.schedule((TimerTask)faultyServiceRectifier, 0L, retryIn);
    }

    public static void stopCacheCleaner() {
        timer.cancel();
        timer = null;
    }

    public static void setActivation(int tenantId, boolean status) {
        activations.put(tenantId, status);
    }

    public static boolean activationRecorded(int tenantId) {
        return activations.get(tenantId) != null;
    }

    public static boolean getActivation(int tenantId) {
        return activations.get(tenantId) != null && activations.get(tenantId) != false;
    }

    private static class CacheCleaner
    extends TimerTask {
        private CacheCleaner() {
        }

        public void run() {
            activations.clear();
        }
    }
}

