/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.sample.installer.beans.SampleInformation;
import org.wso2.carbon.sample.installer.config.SampleConfig;
import org.wso2.carbon.sample.installer.config.SamplesDescConfig;
import org.wso2.carbon.stratos.common.config.CloudServiceConfig;
import org.wso2.carbon.stratos.common.config.CloudServiceConfigParser;
import org.wso2.carbon.stratos.common.util.CloudServicesUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.CarbonUtils;

public class Util {
    private static RegistryService registryService = null;
    private static RealmService realmService = null;
    private static BundleContext bundleContext = null;
    private static List<SampleInformation> sampleInformation = null;
    private static final String CONFIG_FILENAME = "cloud-services-desc.xml";
    private static final String SAMPLES_FILENAME = "samples-desc.xml";
    private static final String TENANT_ID_KEY = "${tenant.id}";
    private static final String TENANT_DOMAIN_KEY = "${tenant.domain}";
    private static final String USER_NAME = "${user.name}";
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final String TENANT_APP_TEMP_DIRECTORY_PATH = "cAppExtractionTemp";
    private static final String TENANT_APP_TEMP_FILE_PATH = "cAppExtractionFile";
    private static final Log log = LogFactory.getLog(Util.class);

    public static synchronized void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static synchronized void setRealmService(RealmService service) {
        realmService = service;
    }

    public static synchronized RealmService getRealmService() {
        return realmService;
    }

    private static UserRegistry getSuperTenantGovernanceSystemRegistry() throws RegistryException {
        return registryService.getGovernanceSystemRegistry();
    }

    public static boolean isCloudServiceActive(String cloudServiceName, int tenantId) throws Exception {
        return CloudServicesUtil.isCloudServiceActive((String)cloudServiceName, (int)tenantId, (UserRegistry)Util.getSuperTenantGovernanceSystemRegistry());
    }

    public static String generateAppArchiveForTenant(String source, HttpSession session) throws IOException {
        return Util.generateAppArchiveForTenant(source, session, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateAppArchiveForTenant(String source, HttpSession session, String propertyFile) throws IOException {
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
        int tenantId = carbonContext.getTenantId();
        if (tenantId <= 0) {
            return source;
        }
        String tenantDomain = carbonContext.getTenantDomain(true);
        String username = carbonContext.getUsername();
        File tempDir = File.createTempFile(TENANT_APP_TEMP_DIRECTORY_PATH, "");
        File tempFile = File.createTempFile(TENANT_APP_TEMP_FILE_PATH, "");
        String dir = tempDir.getAbsolutePath();
        String destination = tempFile.getAbsolutePath() + source.substring(source.lastIndexOf(File.separator));
        try {
            ArchiveManipulator am;
            block25: {
                if (!tempDir.delete() || !tempDir.mkdir()) {
                    tempDir = null;
                    throw new IllegalStateException("Unable to create temporary directory");
                }
                if (!tempFile.delete() || !tempFile.mkdir()) {
                    throw new IllegalStateException("Unable to create temporary directory");
                }
                am = new ArchiveManipulator();
                am.extract(source, dir);
                try {
                    Properties properties;
                    if (propertyFile == null) {
                        propertyFile = source.substring(0, source.lastIndexOf(".")) + PROPERTIES_FILE_EXTENSION;
                    }
                    if ((properties = Util.loadProperties(propertyFile)).size() <= 0) break block25;
                    for (String str : am.check(source)) {
                        try {
                            String filePath = dir + File.separator + str;
                            File file = new File(filePath);
                            if (!file.isFile()) continue;
                            List<String> archiveTypes = Arrays.asList("jar", "aar", "war", "dar", "mar", "gar", "zip");
                            List<String> textTypes = Arrays.asList("xml", "dbs", "xslt", "properties", "service", "js", "jsp", "css", "txt", "wsdl", "bpel");
                            if (FilenameUtils.isExtension((String)filePath, archiveTypes)) {
                                File modified = new File(Util.generateAppArchiveForTenant(filePath, session, propertyFile));
                                FileUtils.copyFile((File)modified, (File)file);
                                FileUtils.deleteDirectory((File)modified.getParentFile());
                                continue;
                            }
                            if (!FilenameUtils.isExtension((String)filePath, textTypes)) continue;
                            StringBuffer oldText = new StringBuffer();
                            BufferedReader reader = new BufferedReader(new FileReader(file));
                            OutputStreamWriter writer = null;
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    oldText.append(line).append("\n");
                                }
                                String newText = oldText.toString();
                                for (String key : properties.stringPropertyNames()) {
                                    String value = properties.getProperty(key).replace(TENANT_ID_KEY, Integer.toString(tenantId)).replace(TENANT_DOMAIN_KEY, tenantDomain).replace(USER_NAME, username);
                                    newText = newText.replace(key, value);
                                }
                                writer = new FileWriter(file);
                                writer.write(newText);
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                finally {
                                    if (writer != null) {
                                        writer.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            log.warn((Object)("An error occurred while making replacements in a file in: " + source), (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("An error occurred while reading properties file for: " + source), (Throwable)e);
                }
            }
            am.archiveDir(destination, dir);
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propertyFileName) throws IOException {
        Properties properties = new Properties();
        File props = new File(propertyFileName);
        if (props.exists()) {
            FileInputStream fileIn = null;
            try {
                fileIn = new FileInputStream(props);
                properties.load(fileIn);
            }
            finally {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
        }
        return properties;
    }

    public static void loadSamplesConfiguration() throws Exception {
        OMElement samplesElement;
        String samplesFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + SAMPLES_FILENAME;
        File samplesFile = new File(samplesFileName);
        if (!samplesFile.exists()) {
            return;
        }
        FileInputStream samplesFileInputStream = new FileInputStream(samplesFile);
        try {
            samplesElement = CommonUtil.buildOMElement((InputStream)samplesFileInputStream);
        }
        catch (Exception e) {
            String msg = "Error in building the samples configuration. config filename: " + samplesFileName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        finally {
            samplesFileInputStream.close();
        }
        SampleConfig[] samplesDescConfig = new SamplesDescConfig(samplesElement).getSampleConfigs();
        sampleInformation = new LinkedList<SampleInformation>();
        if (samplesDescConfig.length > 0) {
            Map cloudServiceConfigs = CloudServiceConfigParser.loadCloudServicesConfiguration().getCloudServiceConfigs();
            for (SampleConfig sample : samplesDescConfig) {
                SampleInformation information = new SampleInformation();
                information.setFileName(sample.getFileName());
                information.setSampleName(sample.getName());
                String[] requiredServices = sample.getCloudServices();
                information.setRequiredServices(requiredServices);
                LinkedList<String> serviceEPRs = new LinkedList<String>();
                for (String service : requiredServices) {
                    serviceEPRs.add(((CloudServiceConfig)cloudServiceConfigs.get(service)).getLink());
                }
                information.setServiceEPRs(serviceEPRs.toArray(new String[serviceEPRs.size()]));
                sampleInformation.add(information);
            }
        }
    }

    public static SampleInformation[] getSampleInformation() {
        LinkedList<SampleInformation> samples = new LinkedList<SampleInformation>();
        for (SampleInformation sample : sampleInformation) {
            SampleInformation temp = new SampleInformation();
            temp.setServiceEPRs(sample.getServiceEPRs());
            temp.setRequiredServices(sample.getRequiredServices());
            temp.setFileName(sample.getFileName());
            temp.setSampleName(sample.getSampleName());
            samples.add(temp);
        }
        return samples.toArray(new SampleInformation[samples.size()]);
    }

    public static void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }
}

