/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sample.installer.utils.Util;
import org.wso2.carbon.user.core.service.RealmService;

public class SampleInstallerServiceComponent {
    private static final Log log = LogFactory.getLog(SampleInstallerServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            Util.loadSamplesConfiguration();
            Util.setBundleContext(context.getBundleContext());
            log.debug((Object)"******* Stratos Sample Installer bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Stratos Sample Installer bundle failed to activate ****", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        Util.setBundleContext(null);
        log.debug((Object)"******* Stratos Sample Installer bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"******* Setting the Realm Service *******");
        }
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }
}

