/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.theme.mgt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;

public class ThemeUtil {
    private static final Log log = LogFactory.getLog(ThemeUtil.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static final String CURRENT_THEME_KEY = "current-theme";
    private static final String THEME_PATH = "/repository/theme";
    private static final String THEME_ADMIN_PATH = "/repository/theme/admin";

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static UserRegistry getThemeMgtSystemRegistry(String tenantPass) throws RegistryException {
        if (tenantPass != null && !tenantPass.equals("")) {
            UserRegistry systemRegistry = registryService.getGovernanceSystemRegistry();
            Resource resource = systemRegistry.get("/repository/components/org.wso2.carbon.theme-page-token/" + tenantPass);
            String tenantIdStr = resource.getProperty("tenantId");
            int tenantId = Integer.parseInt(tenantIdStr);
            return registryService.getGovernanceSystemRegistry(tenantId);
        }
        return null;
    }

    public static void removeTheUUID(String tenantPass) throws RegistryException {
        UserRegistry systemRegistry;
        if (tenantPass != null && !tenantPass.equals("") && (systemRegistry = registryService.getGovernanceSystemRegistry()).resourceExists("/repository/components/org.wso2.carbon.theme-page-token/" + tenantPass)) {
            systemRegistry.delete("/repository/components/org.wso2.carbon.theme-page-token/" + tenantPass);
        }
    }

    public static void transferAllThemesToRegistry(File rootDirectory, Registry registry, String registryPath) throws RegistryException {
        try {
            HashMap<String, String> extensionToMediaTypeMap = new HashMap<String, String>();
            extensionToMediaTypeMap.put("gif", "image/gif");
            extensionToMediaTypeMap.put("jpg", "image/jpeg");
            extensionToMediaTypeMap.put("jpe", "image/jpeg");
            extensionToMediaTypeMap.put("jpeg", "image/jpeg");
            extensionToMediaTypeMap.put("png", "image/png");
            extensionToMediaTypeMap.put("css", "text/css");
            File[] filesAndDirs = rootDirectory.listFiles();
            if (filesAndDirs == null) {
                return;
            }
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                String filename = file.getName();
                String fileRegistryPath = registryPath + "/" + filename;
                if (!file.isFile()) {
                    Collection newCollection = registry.newCollection();
                    registry.put(fileRegistryPath, (Resource)newCollection);
                    ThemeUtil.transferAllThemesToRegistry(file, registry, fileRegistryPath);
                    continue;
                }
                Resource newResource = registry.newResource();
                String mediaType = null;
                if (filename.contains(".")) {
                    String fileExt = filename.substring(filename.lastIndexOf(".") + 1);
                    mediaType = (String)extensionToMediaTypeMap.get(fileExt.toLowerCase());
                }
                if (mediaType == null) {
                    mediaType = new MimetypesFileTypeMap().getContentType(file);
                }
                newResource.setMediaType(mediaType);
                newResource.setContentStream((InputStream)new FileInputStream(file));
                registry.put(fileRegistryPath, newResource);
            }
        }
        catch (Exception e) {
            String msg = "Error loading theme to the sytem registry for registry path: " + registryPath;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static UserRegistry getThemeRegistryFromTenantPass(String tenantPass) throws RegistryException {
        UserRegistry themeMgtSystemRegistry = ThemeUtil.getThemeMgtSystemRegistry(tenantPass);
        if (themeMgtSystemRegistry != null) {
            return themeMgtSystemRegistry.getChrootedRegistry(THEME_ADMIN_PATH);
        }
        return null;
    }

    public static UserRegistry getThemeRegistry(Registry registry) throws RegistryException {
        if (registry == null) {
            return null;
        }
        return ((UserRegistry)registry).getChrootedRegistry(THEME_ADMIN_PATH);
    }

    public static void loadResourceThemes() throws RegistryException {
        UserRegistry systemRegistry = registryService.getGovernanceSystemRegistry();
        String themeRootFileName = System.getProperty("carbon.home") + File.separator + "resources" + File.separator + "allthemes";
        File themeRootFile = new File(themeRootFileName);
        ThemeUtil.transferAllThemesToRegistry(themeRootFile, (Registry)systemRegistry, "/repository/components/org.wso2.carbon.all-themes");
        CommonUtil.setAnonAuthorization((String)"/_system/governance/repository/components/org.wso2.carbon.all-themes", (UserRealm)systemRegistry.getUserRealm());
    }

    public static String[] getAvailableThemes() throws RegistryException {
        UserRegistry systemRegistry = registryService.getGovernanceSystemRegistry();
        if (!systemRegistry.resourceExists("/repository/components/org.wso2.carbon.all-themes")) {
            log.info((Object)"The theme root path: /repository/components/org.wso2.carbon.all-themes doesn't exist.");
            return new String[0];
        }
        Collection c = (Collection)systemRegistry.get("/repository/components/org.wso2.carbon.all-themes");
        String[] childPaths = c.getChildren();
        for (int i = 0; i < childPaths.length; ++i) {
            childPaths[i] = RegistryUtils.getResourceName((String)childPaths[i]);
        }
        return childPaths;
    }

    public static void loadTheme(int tenantId) throws RegistryException {
        UserRegistry systemRegistry = registryService.getGovernanceSystemRegistry(tenantId);
        String[] allThemes = ThemeUtil.getAvailableThemes();
        if (allThemes.length == 0) {
            log.info((Object)"No themes found.");
            return;
        }
        int randomNumber = (int)(Math.random() * (double)allThemes.length);
        String ourLuckyTheme = allThemes[randomNumber];
        ourLuckyTheme = "Default";
        ThemeUtil.applyThemeForDomain(ourLuckyTheme, systemRegistry);
    }

    public static void applyTheme(String themeName, String tenantPass, UserRegistry systemTenantRegistry) throws Exception {
        if (systemTenantRegistry == null) {
            systemTenantRegistry = ThemeUtil.getThemeMgtSystemRegistry(tenantPass);
        }
        ThemeUtil.applyThemeForDomain(themeName, systemTenantRegistry);
    }

    public static void applyThemeForDomain(String themeName, UserRegistry systemTenantRegistry) throws RegistryException {
        String sourcePath = "/repository/components/org.wso2.carbon.all-themes/" + themeName;
        String targetPath = THEME_PATH;
        UserRegistry systemZeroRegistry = registryService.getGovernanceSystemRegistry();
        if (!systemZeroRegistry.resourceExists(sourcePath)) {
            log.info((Object)("The theme source path: " + sourcePath + " doesn't exist."));
            return;
        }
        Resource logoR = null;
        String logoPath = targetPath + "/admin/" + "logo.gif";
        if (systemTenantRegistry.resourceExists(targetPath)) {
            if (systemTenantRegistry.resourceExists(logoPath)) {
                logoR = systemTenantRegistry.get(logoPath);
            }
            if (logoR != null) {
                logoR.getContent();
            }
            systemTenantRegistry.delete(targetPath);
        }
        StringWriter writer = new StringWriter();
        systemZeroRegistry.dump(sourcePath, (Writer)writer);
        StringReader reader = new StringReader(((Object)writer).toString());
        systemTenantRegistry.restore(targetPath, (Reader)reader);
        if (logoR != null) {
            systemTenantRegistry.put(logoPath, logoR);
        }
        Resource tenantThemeCollection = systemTenantRegistry.get(targetPath);
        tenantThemeCollection.setProperty(CURRENT_THEME_KEY, themeName);
        systemTenantRegistry.put(targetPath, tenantThemeCollection);
        try {
            CommonUtil.setAnonAuthorization((String)("/_system/governance" + targetPath), (UserRealm)systemTenantRegistry.getUserRealm());
            CommonUtil.setAnonAuthorization((String)"/_system/governance/repository/components/org.wso2.carbon.all-themes", (UserRealm)systemTenantRegistry.getUserRealm());
        }
        catch (RegistryException e) {
            String msg = "Error in giving authorizations of the " + targetPath + " to the anonymous user and everyone role.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static String getCurrentTheme(String tenantPass, UserRegistry registry) throws Exception {
        String targetPath;
        Resource tenantThemeCollection;
        if (registry == null) {
            registry = ThemeUtil.getThemeMgtSystemRegistry(tenantPass);
        }
        if ((tenantThemeCollection = registry.get(targetPath = THEME_PATH)) == null) {
            return null;
        }
        return tenantThemeCollection.getProperty(CURRENT_THEME_KEY);
    }
}

