/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.usage.agent.persist.BandwidthPersistor;
import org.wso2.carbon.usage.agent.util.MonitoredReader;
import org.wso2.carbon.usage.agent.util.MonitoredWriter;

public class RegistryUsagePersistingListener
extends Handler {
    private static final Log log = LogFactory.getLog(RegistryUsagePersistingListener.class);

    public void put(RequestContext context) throws RegistryException {
        int size;
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return;
        }
        if (CurrentSession.getAttribute((String)"usagePersited") != null) {
            return;
        }
        CurrentSession.setAttribute((String)"usagePersited", (Object)true);
        int tenantId = CurrentSession.getTenantId();
        ResourcePath path = context.getResourcePath();
        Resource resource = context.getResource();
        ((ResourceImpl)resource).setPath(path.getCompletePath());
        if (resource instanceof CollectionImpl) {
            return;
        }
        Object contentObj = resource.getContent();
        if (contentObj == null) {
            return;
        }
        if (contentObj instanceof String) {
            size = ((String)contentObj).length();
        } else if (contentObj instanceof byte[]) {
            size = ((byte[])contentObj).length;
        } else {
            String msg = "Unsupported type for the content.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        BandwidthPersistor.storeIncomingBandwidth(tenantId, size);
    }

    public void importResource(RequestContext context) throws RegistryException {
        URL url;
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return;
        }
        if (CurrentSession.getAttribute((String)"usagePersited") != null) {
            return;
        }
        CurrentSession.setAttribute((String)"usagePersited", (Object)true);
        int tenantId = CurrentSession.getTenantId();
        String sourceURL = context.getSourceURL();
        try {
            if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            url = new URL(sourceURL);
        }
        catch (MalformedURLException e) {
            String msg = "Given source URL " + sourceURL + "is not valid.";
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            URLConnection uc = url.openConnection();
            InputStream in = uc.getInputStream();
            byte[] inByteArr = RegistryUtils.getByteArray((InputStream)in);
            int size = inByteArr.length;
            BandwidthPersistor.storeIncomingBandwidth(tenantId, size);
        }
        catch (IOException e) {
            String msg = "Could not read from the given URL: " + sourceURL;
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public Resource get(RequestContext context) throws RegistryException {
        int size;
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return null;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return null;
        }
        if (CurrentSession.getAttribute((String)"usagePersited") != null) {
            return null;
        }
        CurrentSession.setAttribute((String)"usagePersited", (Object)true);
        int tenantId = CurrentSession.getTenantId();
        Resource resource = context.getResource();
        if (resource == null) {
            ResourcePath resourcePath = context.getResourcePath();
            Registry registry = context.getRegistry();
            if (registry.resourceExists(resourcePath.getPath())) {
                resource = registry.get(resourcePath.getPath());
                context.setResource(resource);
                context.setProcessingComplete(true);
            }
        }
        if (resource == null) {
            return null;
        }
        if (resource instanceof CollectionImpl) {
            return resource;
        }
        Object contentObj = resource.getContent();
        if (contentObj == null) {
            return resource;
        }
        if (contentObj instanceof String) {
            size = ((String)contentObj).length();
        } else if (contentObj instanceof byte[]) {
            size = ((byte[])contentObj).length;
        } else {
            String msg = "Unsupported type for the content.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        BandwidthPersistor.storeOutgoingBandwidth(tenantId, size);
        return resource;
    }

    public void dump(RequestContext requestContext) throws RegistryException {
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return;
        }
        if (CurrentSession.getAttribute((String)"usagePersited") != null) {
            return;
        }
        CurrentSession.setAttribute((String)"usagePersited", (Object)true);
        long size = requestContext.getBytesWritten();
        int tenantId = CurrentSession.getTenantId();
        if (size == 0L) {
            Registry registry = requestContext.getRegistry();
            String path = requestContext.getResourcePath().getPath();
            Writer writer = requestContext.getDumpingWriter();
            MonitoredWriter monitoredWriter = new MonitoredWriter(writer);
            registry.dump(path, (Writer)monitoredWriter);
            size = monitoredWriter.getTotalWritten();
            requestContext.setProcessingComplete(true);
        }
        BandwidthPersistor.storeOutgoingBandwidth(tenantId, size);
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return;
        }
        if (CurrentSession.getAttribute((String)"usagePersited") != null) {
            return;
        }
        CurrentSession.setAttribute((String)"usagePersited", (Object)true);
        int tenantId = CurrentSession.getTenantId();
        long size = requestContext.getBytesRead();
        if (size == 0L) {
            Registry registry = requestContext.getRegistry();
            String path = requestContext.getResourcePath().getPath();
            Reader reader = requestContext.getDumpingReader();
            MonitoredReader monitoredReader = new MonitoredReader(reader);
            registry.restore(path, (Reader)monitoredReader);
            size = monitoredReader.getTotalRead();
            requestContext.setProcessingComplete(true);
        }
        BandwidthPersistor.storeIncomingBandwidth(tenantId, size);
    }

    public static void registerRegistryUsagePersistingListener(RegistryContext registryContext) throws RegistryException {
        HandlerManager handlerManager = registryContext.getHandlerManager();
        RegistryUsagePersistingListener handler = new RegistryUsagePersistingListener();
        URLMatcher anyUrlMatcher = new URLMatcher();
        anyUrlMatcher.setPattern(".*");
        String[] applyingFilters = new String[]{"PUT", "IMPORT", "GET", "DUMP", "RESTORE"};
        handlerManager.addHandlerWithPriority(applyingFilters, (Filter)anyUrlMatcher, (Handler)handler, "reporting");
    }
}

