/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.common.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.stratos.common.config.PermissionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudServiceConfig {
    private static final String CONFIG_NS = "http://wso2.com/carbon/cloud/mgt/services";
    private static final String NAME_ATTR_NAME = "name";
    private static final String DEFAULT_ATTR_NAME = "default";
    private static final String LABEL_ELEMENT_NAME = "label";
    private static final String LINK_ELEMENT_NAME = "link";
    private static final String ICON_ELEMENT_NAME = "icon";
    private static final String DESCRIPTION_ELEMENT_NAME = "description";
    private static final String PERMISSIONS_ELEMENT_NAME = "permissions";
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String PRODUCT_PAGE_URL_ELEMENT_NAME = "productPageURL";
    private String name;
    private String label;
    private String link;
    private String icon;
    private String description;
    private List<PermissionConfig> permissionConfigs = new ArrayList<PermissionConfig>();
    boolean defaultActive;
    private String productPageURL;

    public CloudServiceConfig(OMElement configEle) {
        this.serialize(configEle);
    }

    public void serialize(OMElement configEle) {
        Iterator cloudServiceChildIt = configEle.getChildElements();
        this.name = configEle.getAttributeValue(new QName(null, NAME_ATTR_NAME));
        this.defaultActive = "true".equals(configEle.getAttributeValue(new QName(null, DEFAULT_ATTR_NAME)));
        while (cloudServiceChildIt.hasNext()) {
            Object cloudServiceChildObj = cloudServiceChildIt.next();
            if (!(cloudServiceChildObj instanceof OMElement)) continue;
            OMElement cloudServiceChildEle = (OMElement)cloudServiceChildObj;
            if (new QName(CONFIG_NS, LABEL_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) {
                this.label = cloudServiceChildEle.getText();
                continue;
            }
            if (new QName(CONFIG_NS, ICON_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) {
                this.icon = cloudServiceChildEle.getText();
                continue;
            }
            if (new QName(CONFIG_NS, LINK_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) {
                this.link = cloudServiceChildEle.getText();
                continue;
            }
            if (new QName(CONFIG_NS, PRODUCT_PAGE_URL_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) {
                this.productPageURL = cloudServiceChildEle.getText();
                continue;
            }
            if (new QName(CONFIG_NS, DESCRIPTION_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) {
                this.description = cloudServiceChildEle.getText();
                continue;
            }
            if (!new QName(CONFIG_NS, PERMISSIONS_ELEMENT_NAME, "").equals(cloudServiceChildEle.getQName())) continue;
            Iterator permissionChildIt = cloudServiceChildEle.getChildElements();
            while (permissionChildIt.hasNext()) {
                OMElement permissionChildEle;
                Object permissionChildObj = permissionChildIt.next();
                if (!(permissionChildObj instanceof OMElement) || !new QName(CONFIG_NS, PERMISSION_ELEMENT_NAME, "").equals((permissionChildEle = (OMElement)permissionChildObj).getQName())) continue;
                PermissionConfig permissionConfig = new PermissionConfig(permissionChildEle);
                this.permissionConfigs.add(permissionConfig);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<PermissionConfig> getPermissionConfigs() {
        return this.permissionConfigs;
    }

    public void setPermissionConfigs(List<PermissionConfig> permissionConfigs) {
        this.permissionConfigs = permissionConfigs;
    }

    public boolean isDefaultActive() {
        return this.defaultActive;
    }

    public void setDefaultActive(boolean defaultActive) {
        this.defaultActive = defaultActive;
    }

    public String getProductPageURL() {
        return this.productPageURL;
    }

    public void setProductPageURL(String productPageURL) {
        this.productPageURL = productPageURL;
    }
}

