/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.activation.module;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.activation.utils.ActivationManager;
import org.wso2.carbon.activation.utils.Util;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.stratos.common.util.CloudServicesUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ActivationHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog(ActivationHandler.class);
    private String name = "ActivationHandler";

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting Activation Handler invocation. Incoming Message: " + messageContext.getEnvelope().toString()));
        }
        AxisService service = messageContext.getAxisService();
        int tenantId = this.getTenantId(messageContext);
        if (service != null && "ActivationService".equals(service.getName())) {
            log.debug((Object)"Granted access to the Activation Service");
            if (tenantId > 0) {
                TenantAxisUtils.getTenantAxisConfiguration((String)this.getTenantDomain(messageContext), (ConfigurationContext)messageContext.getConfigurationContext());
                log.debug((Object)"Loaded Tenant Configuration");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        if (tenantId == -1234) {
            log.debug((Object)"Granted access for super tenant");
            return Handler.InvocationResponse.CONTINUE;
        }
        if (ActivationManager.activationRecorded(tenantId)) {
            if (ActivationManager.getActivation(tenantId)) {
                TenantAxisUtils.getTenantAxisConfiguration((String)this.getTenantDomain(messageContext), (ConfigurationContext)messageContext.getConfigurationContext());
                log.debug((Object)"Loaded Tenant Configuration");
                return Handler.InvocationResponse.CONTINUE;
            }
            if (log.isWarnEnabled()) {
                String serviceName = Util.getServiceName();
                log.warn((Object)("Failed attempt to access " + serviceName + " by tenant " + tenantId));
            }
            return Handler.InvocationResponse.ABORT;
        }
        String serviceName = Util.getServiceName();
        try {
            if (CloudServicesUtil.isCloudServiceActive((String)serviceName, (int)tenantId)) {
                log.debug((Object)("Successful attempt to access " + serviceName + " by tenant " + tenantId));
                ActivationManager.setActivation(tenantId, true);
                TenantAxisUtils.getTenantAxisConfiguration((String)this.getTenantDomain(messageContext), (ConfigurationContext)messageContext.getConfigurationContext());
                log.debug((Object)"Loaded Tenant Configuration");
                return Handler.InvocationResponse.CONTINUE;
            }
        }
        catch (Exception e) {
            throw new AxisFault("Failed to determine Activation status.", (Throwable)e);
        }
        log.warn((Object)("Failed attempt to access " + serviceName + " by tenant " + tenantId));
        ActivationManager.setActivation(tenantId, false);
        return Handler.InvocationResponse.ABORT;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getTenantDomain(MessageContext messageContext) {
        return SuperTenantCarbonContext.getCurrentContext((MessageContext)messageContext).getTenantDomain(true);
    }

    private int getTenantId(MessageContext messageContext) {
        OMElement usernameElem;
        SOAPBody soapBody;
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((MessageContext)messageContext);
        int tenantId = carbonContext.getTenantId();
        if (tenantId > -1 || tenantId == -1234) {
            return tenantId;
        }
        String domain = carbonContext.getTenantDomain();
        if (domain == null && (soapBody = messageContext.getEnvelope().getBody()) != null && soapBody.getFirstElement() != null && (usernameElem = soapBody.getFirstElement().getFirstChildWithName(new QName("http://authentication.services.core.carbon.wso2.org", "username"))) != null) {
            String userName = usernameElem.getText();
            domain = MultitenantUtils.getTenantDomain((String)userName);
        }
        if (domain != null) {
            try {
                tenantId = Util.getRealmService().getTenantManager().getTenantId(domain);
            }
            catch (UserStoreException e) {
                log.error((Object)"An error occurred while obtaining the tenant id.", (Throwable)e);
            }
        }
        return tenantId;
    }
}

