/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.redirector.servlet.ui.clients;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.redirector.servlet.stub.RedirectorServletServiceStub;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RedirectorServletServiceClient {
    private static final Log log = LogFactory.getLog(RedirectorServletServiceClient.class);
    private RedirectorServletServiceStub stub;
    private String epr;

    public RedirectorServletServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "RedirectorServletService";
        try {
            this.stub = new RedirectorServletServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public RedirectorServletServiceClient(ServletContext context, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)context, (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)context.getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "RedirectorServletService";
        try {
            this.stub = new RedirectorServletServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String validateTenant(String tenantDomain) throws Exception {
        return this.stub.validateTenant(tenantDomain);
    }
}

