/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.SAML2SSOUIAuthenticatorException;

public class Util {
    private static boolean bootStrapped = false;
    private static Log log = LogFactory.getLog(Util.class);
    private static Random random = new Random();
    private static final char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    private static String serviceProviderId = null;
    private static String identityProviderSSOServiceURL = null;
    private static String loginPage = "/carbon/admin/login.jsp";
    private static String landingPage = null;

    public static XMLObject unmarshall(String authReqStr) throws SAML2SSOUIAuthenticatorException {
        try {
            Util.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(authReqStr.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (Exception e) {
            log.error((Object)"Error in constructing AuthRequest from the encoded String", (Throwable)e);
            throw new SAML2SSOUIAuthenticatorException("Error in constructing AuthRequest from the encoded String ", e);
        }
    }

    public static String marshall(XMLObject xmlObject) throws SAML2SSOUIAuthenticatorException {
        try {
            Util.doBootstrap();
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new SAML2SSOUIAuthenticatorException("Error Serializing the SAML Response", e);
        }
    }

    public static String encode(String xmlString) throws Exception {
        Deflater deflater = new Deflater(8, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(xmlString.getBytes());
        deflaterOutputStream.close();
        String encodedRequestMessage = org.opensaml.xml.util.Base64.encodeBytes((byte[])byteArrayOutputStream.toByteArray(), (int)8);
        return encodedRequestMessage.trim();
    }

    public static String decode(String encodedStr) throws SAML2SSOUIAuthenticatorException {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            try {
                Inflater inflater = new Inflater(true);
                inflater.setInput(base64DecodedByteArray);
                byte[] xmlMessageBytes = new byte[5000];
                int resultLength = inflater.inflate(xmlMessageBytes);
                if (inflater.getRemaining() > 0) {
                    throw new RuntimeException("didn't allocate enough space to hold decompressed data");
                }
                inflater.end();
                return new String(xmlMessageBytes, 0, resultLength, "UTF-8");
            }
            catch (DataFormatException e) {
                ByteArrayInputStream bais = new ByteArrayInputStream(base64DecodedByteArray);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InflaterInputStream iis = new InflaterInputStream(bais);
                byte[] buf = new byte[1024];
                int count = iis.read(buf);
                while (count != -1) {
                    baos.write(buf, 0, count);
                    count = iis.read(buf);
                }
                iis.close();
                String decodedStr = new String(baos.toByteArray());
                return decodedStr;
            }
        }
        catch (IOException e) {
            throw new SAML2SSOUIAuthenticatorException("Error when decoding the SAML Request.", e);
        }
    }

    public static void doBootstrap() {
        if (!bootStrapped) {
            try {
                DefaultBootstrap.bootstrap();
                bootStrapped = true;
            }
            catch (ConfigurationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML2 library", (Throwable)e);
            }
        }
    }

    public static Response setSignature(Response response, String signatureAlgorithm, X509Credential cred) throws SAML2SSOUIAuthenticatorException {
        Util.doBootstrap();
        try {
            Signature signature = (Signature)Util.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)Util.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)Util.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)Util.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = org.apache.xml.security.utils.Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                throw new SAML2SSOUIAuthenticatorException("errorGettingCert");
            }
            response.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)response);
            marshaller.marshall((XMLObject)response);
            Init.init();
            Signer.signObjects(signatureList);
            return response;
        }
        catch (Exception e) {
            throw new SAML2SSOUIAuthenticatorException("Error When signing the assertion.", e);
        }
    }

    public static XMLObject buildXMLObject(QName objectQName) throws SAML2SSOUIAuthenticatorException {
        XMLObjectBuilder builder = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new SAML2SSOUIAuthenticatorException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static String createID() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
        }
        return String.valueOf(chars);
    }

    public static boolean initSSOConfigParams() {
        boolean initSuccess = false;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null) {
            Map parameters = authenticatorConfig.getParameters();
            serviceProviderId = (String)parameters.get("ServiceProviderID");
            identityProviderSSOServiceURL = (String)parameters.get("IdentityProviderSSOServiceURL");
            loginPage = (String)parameters.get("LoginPage");
            landingPage = (String)parameters.get("LandingPage");
            initSuccess = true;
        }
        return initSuccess;
    }

    public static boolean isAuthenticatorEnabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        return !authenticatorConfig.isDisabled();
    }

    public static String getServiceProviderId() {
        return serviceProviderId;
    }

    public static String getIdentityProviderSSOServiceURL() {
        return identityProviderSSOServiceURL;
    }

    public static String getLoginPage() {
        return loginPage;
    }

    public static String getLandingPage() {
        return landingPage;
    }
}

